/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.naming.interval;

import java.time.format.DateTimeFormatter;
import org.anchoranalysis.core.exception.friendly.AnchorImpossibleSituationException;
import org.anchoranalysis.plugin.io.naming.interval.DateStyle;

public enum TimeStyle {
    INCLUDE_ENTIRELY,
    IGNORE_SECONDS,
    OMIT;

    private static final String TIME_WITH_SECONDS_PATTERN = "HH.mm.ss";
    private static final String TIME_WITHOUT_SECONDS_PATTERN = "HH.mm";

    public DateTimeFormatter patternWithDate(DateStyle dateStyle) {
        String timePattern;
        if (this == OMIT) {
            throw new AnchorImpossibleSituationException();
        }
        String string = timePattern = this == IGNORE_SECONDS ? TIME_WITHOUT_SECONDS_PATTERN : TIME_WITH_SECONDS_PATTERN;
        if (dateStyle != DateStyle.OMIT) {
            return DateTimeFormatter.ofPattern(dateStyle.pattern() + " " + timePattern);
        }
        return DateTimeFormatter.ofPattern(timePattern);
    }
}

