/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.shared;

import java.util.Map;
import java.util.TreeMap;
import org.anchoranalysis.core.value.LanguageUtilities;

public class FrequencyMap<T> {
    private Map<T, Integer> map = new TreeMap<T, Integer>();

    public synchronized void incrementCount(T key) {
        Integer count = this.map.get(key);
        if (count == null) {
            this.map.put(key, 1);
        } else {
            this.map.put(key, count + 1);
        }
    }

    public synchronized String describe(String dscrNoun) {
        int numKeys = this.map.keySet().size();
        if (numKeys == 0) {
            return "No inputs have been found yet.";
        }
        if (numKeys == 1) {
            return String.format("with uniform %s = %s", dscrNoun, this.map.keySet().iterator().next());
        }
        return this.describeDiverse(dscrNoun);
    }

    private String describeDiverse(String dscrNoun) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("with diverse %s:", LanguageUtilities.pluralize((String)dscrNoun)));
        for (Map.Entry<T, Integer> entry : this.map.entrySet()) {
            sb.append(String.format(" %s(%d)", entry.getKey(), entry.getValue()));
        }
        return sb.toString();
    }
}

