/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.shared;

public class NumberToStringConverter {
    private String formatString;

    public NumberToStringConverter(int maxNumberToRepresent) {
        this.formatString = NumberToStringConverter.createFormatStringForMaxNumber(maxNumberToRepresent);
    }

    public String convert(int number) {
        return String.format(this.formatString, number);
    }

    private static String createFormatStringForMaxNumber(int maxNumberToRepresent) {
        int maxNumberDigits = (int)Math.ceil(Math.log10(maxNumberToRepresent));
        if (maxNumberDigits > 0) {
            return "%0" + maxNumberDigits + "d";
        }
        return "%d";
    }
}

