/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.shared;

import java.nio.file.Path;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.experiment.log.StatefulMessageLogger;
import org.anchoranalysis.experiment.log.TextFileMessageLogger;
import org.anchoranalysis.io.output.outputter.Outputter;
import org.anchoranalysis.math.arithmetic.Counter;
import org.anchoranalysis.plugin.io.shared.PathMappingCSV;

public class RecordingCounter<T> {
    private static final String OUTPUT_COPY_LOG = "copyLog";
    private static final String OUTPUT_PATH_MAPPING = "pathMapping";
    private final Counter counter;
    private final StatefulMessageLogger logger;
    private final PathMappingCSV pathMapping;
    private final T namingSharedState;
    private Set<Path> destinationPaths = new HashSet<Path>();

    public RecordingCounter(Counter counter, Outputter outputter, T namingSharedState) throws OperationFailedException {
        this.counter = counter;
        this.namingSharedState = namingSharedState;
        this.logger = new TextFileMessageLogger(OUTPUT_COPY_LOG, outputter.getChecked(), outputter.getErrorReporter());
        this.logger.start();
        this.pathMapping = new PathMappingCSV(OUTPUT_PATH_MAPPING, outputter);
    }

    public synchronized int incrementCounter() {
        int index = this.counter.getCount();
        this.counter.increment();
        return index;
    }

    public void recordCopiedOutput(Path source, Optional<Path> destination, int index) throws OperationFailedException {
        if (destination.isPresent()) {
            if (!this.destinationPaths.add(destination.get())) {
                throw new OperationFailedException(String.format("A file with destination %s has already been copied. There is a duplicate destination-path for two different files!", destination.get()));
            }
            this.logger.logFormatted("Copying %s to %s", new Object[]{source, destination.get().toString()});
            this.pathMapping.maybeWriteRow(source, destination.get(), index);
        } else {
            this.logger.logFormatted("Skipping %s", new Object[]{source});
        }
    }

    public void closeLogger() {
        this.logger.close(true, false);
    }

    public T getNamingSharedState() {
        return this.namingSharedState;
    }
}

