/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.file.copy.naming;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import org.anchoranalysis.core.system.path.ExtensionUtilities;
import org.anchoranalysis.io.input.file.FileWithDirectoryInput;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;
import org.anchoranalysis.io.output.path.prefixer.DirectoryWithPrefix;
import org.anchoranalysis.plugin.io.bean.file.copy.naming.CopyFilesNaming;
import org.anchoranalysis.plugin.io.input.path.CopyContext;
import org.anchoranalysis.plugin.io.shared.AnonymizeSharedState;
import org.anchoranalysis.plugin.io.shared.NumberToStringConverter;

public class Anonymize
extends CopyFilesNaming<AnonymizeSharedState> {
    @Override
    public AnonymizeSharedState beforeCopying(Path destinationDirectory, List<FileWithDirectoryInput> inputs) {
        int size = inputs.size();
        return new AnonymizeSharedState(new NumberToStringConverter(size), Anonymize.createMappingToShuffledIndices(size));
    }

    @Override
    public Optional<Path> destinationPathRelative(File file, DirectoryWithPrefix outputTarget, int iter, CopyContext<AnonymizeSharedState> context) throws OutputWriteFailedException {
        Integer mappedIteration = context.getSharedState().getMapping().get(iter);
        if (mappedIteration == null) {
            throw new OutputWriteFailedException("An unexpected value was passed as iteration, and no mapping is available: " + iter);
        }
        Optional extension = ExtensionUtilities.extractExtension((String)file.toString());
        String filenameToCopyTo = ExtensionUtilities.appendExtension((String)context.getSharedState().getNumberConverter().convert(mappedIteration), (Optional)extension);
        return Optional.of(Paths.get(filenameToCopyTo, new String[0]));
    }

    private static Map<Integer, Integer> createMappingToShuffledIndices(int totalNumberFiles) {
        List<Integer> indices = Anonymize.createSequence(totalNumberFiles);
        Collections.shuffle(indices);
        return Anonymize.mapIndexToElement(indices);
    }

    private static List<Integer> createSequence(int maxNumberExclusive) {
        return IntStream.range(0, maxNumberExclusive).boxed().toList();
    }

    private static <T> Map<Integer, T> mapIndexToElement(List<T> list) {
        HashMap<Integer, T> map = new HashMap<Integer, T>();
        for (int i = 0; i < list.size(); ++i) {
            map.put(i, list.get(i));
        }
        return map;
    }
}

