/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.file.copy.naming.cluster;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.exception.friendly.AnchorImpossibleSituationException;
import org.anchoranalysis.core.functional.FunctionalList;
import org.anchoranalysis.core.system.path.PathDifferenceException;
import org.anchoranalysis.io.input.file.FileWithDirectoryInput;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;
import org.anchoranalysis.io.output.path.prefixer.DirectoryWithPrefix;
import org.anchoranalysis.plugin.io.bean.file.copy.naming.CopyFilesNaming;
import org.anchoranalysis.plugin.io.bean.file.copy.naming.cluster.ClusterIdentifier;
import org.anchoranalysis.plugin.io.bean.file.copy.naming.cluster.DeriveTimestampedFiles;
import org.anchoranalysis.plugin.io.bean.file.copy.naming.cluster.PopulateClusterMembership;
import org.anchoranalysis.plugin.io.bean.file.copy.naming.cluster.TimestampedFile;
import org.anchoranalysis.plugin.io.bean.file.pattern.TimestampPattern;
import org.anchoranalysis.plugin.io.file.copy.ClusterMembership;
import org.anchoranalysis.plugin.io.file.copy.PathOperations;
import org.anchoranalysis.plugin.io.input.path.CopyContext;

public class ClusterByTimestamp
extends CopyFilesNaming<ClusterMembership> {
    private static final String OUTLIER_CLUSTER_IDENTIFIER = "outliers";
    @BeanField
    private double thresholdHours = 1.0;
    @BeanField
    private int minimumPerCluster = 1;
    @BeanField
    private boolean preserveSubdirectories = false;
    @BeanField
    private List<TimestampPattern> timestampPatterns = ClusterByTimestamp.defaultDateTimePatterns();
    @BeanField
    private int timeZoneOffset = -1;

    @Override
    public ClusterMembership beforeCopying(Path destinationDirectory, List<FileWithDirectoryInput> inputs) throws OperationFailedException {
        ZoneOffset offset = this.offset();
        ClusterMembership membership = new ClusterMembership(new ClusterIdentifier(OUTLIER_CLUSTER_IDENTIFIER, offset));
        DeriveTimestampedFiles derive = new DeriveTimestampedFiles(this.timestampPatterns);
        List<TimestampedFile> timestampedFiles = derive.derive(inputs, offset);
        PopulateClusterMembership populate = new PopulateClusterMembership(membership, offset);
        populate.populateFrom(timestampedFiles, derive.getScaler(), offset, this.thresholdHours, this.minimumPerCluster);
        return membership;
    }

    @Override
    public Optional<Path> destinationPathRelative(File file, DirectoryWithPrefix outputTarget, int index, CopyContext<ClusterMembership> context) throws OutputWriteFailedException {
        try {
            return this.pathForFile(context.getSourceDirectory(), file.toPath(), context.getSharedState().clusterFor(file));
        }
        catch (PathDifferenceException e) {
            throw new OutputWriteFailedException((Throwable)e);
        }
    }

    private Optional<Path> pathForFile(Path sourceDirectory, Path file, ClusterIdentifier clusterIdentifier) throws PathDifferenceException {
        Path relative = PathOperations.filePathDifference(sourceDirectory, file);
        if (!this.preserveSubdirectories) {
            relative = relative.getFileName();
        }
        try {
            return Optional.of(Paths.get(clusterIdentifier.name(), new String[0]).resolve(relative));
        }
        catch (OperationFailedException e) {
            throw new AnchorImpossibleSituationException();
        }
    }

    private ZoneOffset offset() {
        if (this.timeZoneOffset == -1) {
            return OffsetDateTime.now().getOffset();
        }
        if (this.timeZoneOffset >= 0) {
            return ZoneOffset.ofHours(this.timeZoneOffset);
        }
        throw new AnchorImpossibleSituationException();
    }

    private static List<TimestampPattern> defaultDateTimePatterns() {
        List<String> patterns = Arrays.asList(".*(\\d\\d\\d\\d)-(\\d\\d)-(\\d\\d) (\\d\\d)\\.(\\d\\d)\\.(\\d\\d).*", ".*(\\d\\d\\d\\d)(\\d\\d)(\\d\\d)_(\\d\\d)(\\d\\d)(\\d\\d)\\D.*", ".*(\\d\\d\\d\\d)(\\d\\d)(\\d\\d) (\\d\\d)(\\d\\d)(\\d\\d)\\D.*");
        return FunctionalList.mapToList(patterns, TimestampPattern::new);
    }

    @Generated
    public double getThresholdHours() {
        return this.thresholdHours;
    }

    @Generated
    public void setThresholdHours(double thresholdHours) {
        this.thresholdHours = thresholdHours;
    }

    @Generated
    public int getMinimumPerCluster() {
        return this.minimumPerCluster;
    }

    @Generated
    public void setMinimumPerCluster(int minimumPerCluster) {
        this.minimumPerCluster = minimumPerCluster;
    }

    @Generated
    public boolean isPreserveSubdirectories() {
        return this.preserveSubdirectories;
    }

    @Generated
    public void setPreserveSubdirectories(boolean preserveSubdirectories) {
        this.preserveSubdirectories = preserveSubdirectories;
    }

    @Generated
    public List<TimestampPattern> getTimestampPatterns() {
        return this.timestampPatterns;
    }

    @Generated
    public void setTimestampPatterns(List<TimestampPattern> timestampPatterns) {
        this.timestampPatterns = timestampPatterns;
    }

    @Generated
    public int getTimeZoneOffset() {
        return this.timeZoneOffset;
    }

    @Generated
    public void setTimeZoneOffset(int timeZoneOffset) {
        this.timeZoneOffset = timeZoneOffset;
    }
}

