/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.file.copy.naming.cluster;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import loci.common.services.ServiceException;
import loci.formats.services.EXIFServiceImpl;
import lombok.Generated;
import org.anchoranalysis.core.format.ImageFileFormat;
import org.anchoranalysis.core.functional.OptionalUtilities;
import org.anchoranalysis.plugin.io.bean.file.pattern.TimestampPattern;

class DateTimeAssociator {
    private final List<TimestampPattern> filenamePatterns;

    public long associateDateTime(File file, ZoneOffset offset) throws IOException {
        Optional<Long> exifTimestamp;
        if (ImageFileFormat.JPEG.matches(file.getName()) && (exifTimestamp = DateTimeAssociator.readEXIFCreationTime(file)).isPresent()) {
            return exifTimestamp.get();
        }
        Optional<Long> extractedTime = this.extractTimeFromFilename(file.getName(), offset);
        if (extractedTime.isPresent()) {
            return extractedTime.get();
        }
        return DateTimeAssociator.readFileCreationTime(file);
    }

    private Optional<Long> extractTimeFromFilename(String fileName, ZoneOffset offset) {
        Stream<Optional> extractedDateTime = this.filenamePatterns.stream().map(pattern -> pattern.match(fileName, offset));
        return OptionalUtilities.orFlat(extractedDateTime);
    }

    private static long readFileCreationTime(File file) throws IOException {
        BasicFileAttributes attributes = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
        return attributes.creationTime().toMillis() / 1000L;
    }

    private static Optional<Long> readEXIFCreationTime(File file) {
        EXIFServiceImpl exif = new EXIFServiceImpl();
        try {
            exif.initialize(file.toString());
        }
        catch (IOException | ServiceException e) {
            return Optional.empty();
        }
        if (exif.getCreationDate() != null) {
            return Optional.of(exif.getCreationDate().toInstant().getEpochSecond());
        }
        return Optional.empty();
    }

    @Generated
    public DateTimeAssociator(List<TimestampPattern> filenamePatterns) {
        this.filenamePatterns = filenamePatterns;
    }
}

