/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.file.copy.naming.cluster;

import java.time.LocalDate;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.plugin.io.bean.file.copy.naming.cluster.ClusterIdentifier;
import org.anchoranalysis.plugin.io.bean.file.copy.naming.cluster.IndexClustersByTime;
import org.anchoranalysis.plugin.io.naming.interval.DateStyle;
import org.anchoranalysis.plugin.io.naming.interval.TimeIntervalNamer;
import org.anchoranalysis.plugin.io.naming.interval.TimeStyle;

class EstablishClusterNames {
    public static void assignNames(List<ClusterIdentifier> identifiers) throws OperationFailedException {
        Set<String> namesAsSet = EstablishClusterNames.createNameSet(identifiers, EstablishClusterNames.dateStyle(identifiers));
        if (namesAsSet.size() != identifiers.size()) {
            throw new OperationFailedException("The names of the clusters are not unique, abandoning. This shouldn't happen so is indicative of an internal error.");
        }
    }

    private static DateStyle dateStyle(List<ClusterIdentifier> identifiers) {
        if (EstablishClusterNames.hasUniformYear(identifiers)) {
            if (EstablishClusterNames.hasUniformDay(identifiers)) {
                return DateStyle.OMIT;
            }
            return DateStyle.IGNORE_YEAR;
        }
        return DateStyle.INCLUDE_ENTIRELY;
    }

    private static Set<String> createNameSet(List<ClusterIdentifier> identifiers, DateStyle dateStyle) {
        IndexClustersByTime treeMinutes = new IndexClustersByTime(identifiers);
        return identifiers.stream().map(identifier -> EstablishClusterNames.createNameAndAssign(identifier, dateStyle, treeMinutes)).collect(Collectors.toSet());
    }

    private static String createNameAndAssign(ClusterIdentifier identifier, DateStyle dateStyle, IndexClustersByTime tree) {
        String name = new TimeIntervalNamer(identifier.getOffset()).nameFor(identifier.getMinTime(), identifier.getMaxTime(), dateStyle, EstablishClusterNames.timeStyle(identifier, tree));
        identifier.assignName(name);
        return name;
    }

    private static TimeStyle timeStyle(ClusterIdentifier identifier, IndexClustersByTime tree) {
        if (tree.usesDaysExclusively(identifier)) {
            return TimeStyle.OMIT;
        }
        if (tree.usesMinutesExclusively(identifier)) {
            return TimeStyle.IGNORE_SECONDS;
        }
        return TimeStyle.INCLUDE_ENTIRELY;
    }

    private static boolean hasUniformYear(List<ClusterIdentifier> clusters) {
        int running = clusters.get(0).getMinTime().getYear();
        for (ClusterIdentifier identifier : clusters) {
            if (identifier.getMinTime().getYear() != running) {
                return false;
            }
            if (identifier.getMaxTime().getYear() == running) continue;
            return false;
        }
        return true;
    }

    private static boolean hasUniformDay(List<ClusterIdentifier> clusters) {
        LocalDate running = clusters.get(0).getMinTime().toLocalDate();
        for (ClusterIdentifier identifier : clusters) {
            if (!identifier.getMinTime().toLocalDate().equals(running)) {
                return false;
            }
            if (identifier.getMaxTime().toLocalDate().equals(running)) continue;
            return false;
        }
        return true;
    }

    @Generated
    private EstablishClusterNames() {
    }
}

