/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.file.copy.naming.cluster;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.List;
import org.anchoranalysis.plugin.io.bean.file.copy.naming.cluster.ClusterIdentifier;
import org.anchoranalysis.spatial.rtree.IntervalRTree;

class IndexClustersByTime {
    private final IntervalRTree<ClusterIdentifier> tree;

    public IndexClustersByTime(List<ClusterIdentifier> identifiers) {
        this.tree = new IntervalRTree(identifiers.size());
        for (ClusterIdentifier identifier : identifiers) {
            this.tree.add((double)IndexClustersByTime.epochMinute(identifier.getMinInstant()), (double)IndexClustersByTime.epochMinute(identifier.getMinInstant()), (Object)identifier);
        }
    }

    public boolean usesDaysExclusively(ClusterIdentifier identifier) {
        LocalDateTime startDay = identifier.getMinTime().toLocalDate().atTime(0, 0, 0);
        LocalDateTime endDay = identifier.getMaxTime().toLocalDate().atTime(23, 59, 59);
        return this.usesRangeExclusively(this.epochMinute(startDay, identifier.getOffset()), this.epochMinute(endDay, identifier.getOffset()));
    }

    public boolean usesMinutesExclusively(ClusterIdentifier identifier) {
        return this.usesRangeExclusively(IndexClustersByTime.epochMinute(identifier.getMinInstant()), IndexClustersByTime.epochMinute(identifier.getMaxInstant()));
    }

    private boolean usesRangeExclusively(long start, long end) {
        int numberIntersecting = this.tree.intersectsWith((double)start, (double)end).size();
        assert (numberIntersecting > 0);
        return numberIntersecting == 1;
    }

    private long epochMinute(LocalDateTime timestamp, ZoneOffset offset) {
        return IndexClustersByTime.epochMinute(timestamp.toEpochSecond(offset));
    }

    private static long epochMinute(long instant) {
        return instant / 60L;
    }
}

