/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.file.copy.naming.cluster;

import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.math.statistics.MeanScale;
import org.anchoranalysis.plugin.io.bean.file.copy.naming.cluster.ClusterIdentifier;
import org.anchoranalysis.plugin.io.bean.file.copy.naming.cluster.EstablishClusterNames;
import org.anchoranalysis.plugin.io.bean.file.copy.naming.cluster.TimestampedFile;
import org.anchoranalysis.plugin.io.file.copy.ClusterMembership;
import org.apache.commons.math3.ml.clustering.Cluster;
import org.apache.commons.math3.ml.clustering.DBSCANClusterer;

class PopulateClusterMembership {
    private static final int SECONDS_IN_HOUR = 3600;
    private ClusterMembership membership;
    private ZoneOffset offset;

    public void populateFrom(List<TimestampedFile> files, MeanScale scaler, ZoneOffset offset, double thresholdHours, int minimumPerCluster) throws OperationFailedException {
        if (scaler.getScale() >= 0.0) {
            this.addAfterClustering(files, PopulateClusterMembership.calculateEps(thresholdHours, scaler.getScale()), minimumPerCluster);
        } else {
            this.addToSingleCluster(files, offset);
        }
    }

    private void addToSingleCluster(List<TimestampedFile> files, ZoneOffset offset) throws OperationFailedException {
        ClusterIdentifier identifier = new ClusterIdentifier(offset);
        for (TimestampedFile file : files) {
            this.membership.associateFileWithCluster(file.getFile(), file.getTimestamp(), identifier);
        }
        EstablishClusterNames.assignNames(Arrays.asList(identifier));
    }

    private void addAfterClustering(List<TimestampedFile> files, double eps, int minimumPerCluster) throws OperationFailedException {
        DBSCANClusterer clusterer = new DBSCANClusterer(eps, minimumPerCluster);
        List clusters = clusterer.cluster(files);
        if (clusters.isEmpty()) {
            return;
        }
        ArrayList<ClusterIdentifier> identifiers = new ArrayList<ClusterIdentifier>();
        for (Cluster cluster : clusters) {
            identifiers.add(this.addClusterToMapping((Cluster<TimestampedFile>)cluster));
        }
        EstablishClusterNames.assignNames(identifiers);
    }

    private ClusterIdentifier addClusterToMapping(Cluster<TimestampedFile> cluster) throws OperationFailedException {
        ClusterIdentifier clusterIdentifier = new ClusterIdentifier(this.offset);
        for (TimestampedFile file : cluster.getPoints()) {
            this.membership.associateFileWithCluster(file.getFile(), file.getTimestamp(), clusterIdentifier);
        }
        return clusterIdentifier;
    }

    private static double calculateEps(double thresholdHours, double scale) {
        return thresholdHours * 3600.0 / scale;
    }

    @Generated
    public PopulateClusterMembership(ClusterMembership membership, ZoneOffset offset) {
        this.membership = membership;
        this.offset = offset;
    }
}

