/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.file.copy.naming.cluster;

import java.io.File;
import java.io.IOException;
import java.time.ZoneOffset;
import lombok.Generated;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.math.statistics.MeanScale;
import org.anchoranalysis.math.statistics.VarianceCalculatorDouble;
import org.anchoranalysis.plugin.io.bean.file.copy.naming.cluster.DateTimeAssociator;
import org.apache.commons.math3.ml.clustering.Clusterable;

class TimestampedFile
implements Clusterable {
    private final File file;
    private long timestamp;
    private double normalizedTimestamp;

    public TimestampedFile(File file, VarianceCalculatorDouble varianceCreationTime, DateTimeAssociator dateTimeAssociator, ZoneOffset offset) throws CreateException {
        try {
            this.file = file;
            this.timestamp = dateTimeAssociator.associateDateTime(file, offset);
            varianceCreationTime.add((double)this.timestamp);
        }
        catch (IOException e) {
            throw new CreateException((Throwable)e);
        }
    }

    public void normalize(MeanScale meanScaleDateTime) {
        this.normalizedTimestamp = meanScaleDateTime.zScore((double)this.timestamp);
    }

    public double[] getPoint() {
        return new double[]{this.normalizedTimestamp};
    }

    @Generated
    public File getFile() {
        return this.file;
    }

    @Generated
    public long getTimestamp() {
        return this.timestamp;
    }
}

