/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.file.group.parser;

import java.nio.file.Path;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.system.path.FilePathToUnixStyleConverter;
import org.anchoranalysis.plugin.io.bean.file.group.parser.ExtractGroup;
import org.anchoranalysis.plugin.io.bean.file.group.parser.FilePathParser;
import org.anchoranalysis.plugin.io.multifile.FileDetails;

public class RegularExpression
extends FilePathParser {
    @BeanField
    private String expression;
    @BeanField
    private int channelGroupID = 0;
    @BeanField
    private int zSliceGroupID = 0;
    @BeanField
    private int timeIndexGroupID = 0;
    @BeanField
    private int keyGroupID = 0;
    @BeanField
    private boolean keyRequired = false;
    private String key;
    Pattern pattern = null;

    @Override
    public Optional<FileDetails> parsePath(Path path) {
        Matcher matcher = this.pattern.matcher(FilePathToUnixStyleConverter.toStringUnixStyle((Path)path.toAbsolutePath()));
        if (!matcher.matches()) {
            return Optional.empty();
        }
        int channelNum = ExtractGroup.maybeExtractInt(this.channelGroupID, matcher);
        int zSliceNum = ExtractGroup.maybeExtractInt(this.zSliceGroupID, matcher);
        int timeIndex = ExtractGroup.maybeExtractInt(this.timeIndexGroupID, matcher);
        if (channelNum == -1 || zSliceNum == -1 || timeIndex == -1) {
            return Optional.empty();
        }
        if (this.keyGroupID > 0) {
            Optional<String> extractedKey = ExtractGroup.extractString(this.keyGroupID, matcher);
            if (!extractedKey.isPresent() || extractedKey.get().isEmpty() && this.keyRequired) {
                return Optional.empty();
            }
            this.key = extractedKey.get();
        }
        return Optional.of(new FileDetails(path, RegularExpression.asOptional(this.channelGroupID, channelNum), RegularExpression.asOptional(this.zSliceGroupID, zSliceNum), RegularExpression.asOptional(this.timeIndexGroupID, timeIndex)));
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public void setExpression(String expression) {
        this.expression = expression;
        this.pattern = Pattern.compile(expression);
    }

    private static Optional<Integer> asOptional(int groupID, int val) {
        if (groupID > 0) {
            return Optional.of(val);
        }
        return Optional.empty();
    }

    @Generated
    public String getExpression() {
        return this.expression;
    }

    @Generated
    public int getChannelGroupID() {
        return this.channelGroupID;
    }

    @Generated
    public void setChannelGroupID(int channelGroupID) {
        this.channelGroupID = channelGroupID;
    }

    @Generated
    public int getZSliceGroupID() {
        return this.zSliceGroupID;
    }

    @Generated
    public void setZSliceGroupID(int zSliceGroupID) {
        this.zSliceGroupID = zSliceGroupID;
    }

    @Generated
    public int getTimeIndexGroupID() {
        return this.timeIndexGroupID;
    }

    @Generated
    public void setTimeIndexGroupID(int timeIndexGroupID) {
        this.timeIndexGroupID = timeIndexGroupID;
    }

    @Generated
    public int getKeyGroupID() {
        return this.keyGroupID;
    }

    @Generated
    public void setKeyGroupID(int keyGroupID) {
        this.keyGroupID = keyGroupID;
    }

    @Generated
    public boolean isKeyRequired() {
        return this.keyRequired;
    }

    @Generated
    public void setKeyRequired(boolean keyRequired) {
        this.keyRequired = keyRequired;
    }
}

