/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.file.namer;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.functional.FunctionalList;
import org.anchoranalysis.core.system.path.ExtensionUtilities;
import org.anchoranalysis.core.system.path.FilePathToUnixStyleConverter;
import org.anchoranalysis.io.input.bean.namer.FileNamer;
import org.anchoranalysis.io.input.file.FileNamerContext;
import org.anchoranalysis.io.input.file.NamedFile;

public class RemoveExtension
extends FileNamer {
    @BeanField
    private FileNamer namer;
    @BeanField
    private boolean preserveExtensionIfDuplicate = true;

    public RemoveExtension(FileNamer namer) {
        this.namer = namer;
    }

    public List<NamedFile> deriveName(List<File> files, FileNamerContext context) {
        List namedFiles = this.namer.deriveName(files, context);
        if (this.preserveExtensionIfDuplicate) {
            return RemoveExtension.considerDuplicates(namedFiles, context.getElseName());
        }
        return RemoveExtension.removeExtension(namedFiles, context.getElseName());
    }

    private static List<NamedFile> considerDuplicates(List<NamedFile> files, String elseName) {
        List<NamedFile> withoutExtension = RemoveExtension.removeExtension(files, elseName);
        Map<String, Long> count = withoutExtension.stream().collect(Collectors.groupingBy(NamedFile::getIdentifier, Collectors.counting()));
        return RemoveExtension.listMaybeWithExtension(files, withoutExtension, count);
    }

    private static List<NamedFile> listMaybeWithExtension(List<NamedFile> listWith, List<NamedFile> listWithout, Map<String, Long> countWithout) {
        ArrayList<NamedFile> out = new ArrayList<NamedFile>();
        for (int i = 0; i < listWith.size(); ++i) {
            NamedFile without = listWithout.get(i);
            long count = countWithout.get(without.getIdentifier());
            out.add(count > 1L ? listWith.get(i) : without);
        }
        return out;
    }

    private static List<NamedFile> removeExtension(List<NamedFile> files, String elseName) {
        return FunctionalList.mapToList(files, file -> RemoveExtension.maybeRemoveExtension(file, elseName));
    }

    private static NamedFile maybeRemoveExtension(NamedFile file, String elseName) {
        String maybeExtensionRemoved = RemoveExtension.maybeRemoveExtensionForwardSlashes(file.getIdentifier(), file.getPath());
        if (maybeExtensionRemoved.isEmpty()) {
            maybeExtensionRemoved = elseName;
        }
        return new NamedFile(maybeExtensionRemoved, file.getFile());
    }

    private static String maybeRemoveExtensionForwardSlashes(String nameLikePath, Path path) {
        String pathForwardSlash = FilePathToUnixStyleConverter.toStringUnixStyle((Path)path.normalize());
        if (!pathForwardSlash.endsWith(nameLikePath)) {
            return nameLikePath;
        }
        return FilePathToUnixStyleConverter.toStringUnixStyle((String)RemoveExtension.removeExtension(nameLikePath));
    }

    private static String removeExtension(String nameLikePath) {
        Path path = Paths.get(nameLikePath, new String[0]);
        Path fileNamePart = path.getFileName();
        String fileNamePartRemoved = ExtensionUtilities.removeExtension((String)fileNamePart.toString());
        fileNamePartRemoved = fileNamePartRemoved.trim();
        if (path.getParent() != null) {
            return path.getParent().resolve(fileNamePartRemoved).toString();
        }
        return fileNamePartRemoved;
    }

    @Generated
    public RemoveExtension() {
    }

    @Generated
    public FileNamer getNamer() {
        return this.namer;
    }

    @Generated
    public void setNamer(FileNamer namer) {
        this.namer = namer;
    }

    @Generated
    public boolean isPreserveExtensionIfDuplicate() {
        return this.preserveExtensionIfDuplicate;
    }

    @Generated
    public void setPreserveExtensionIfDuplicate(boolean preserveExtensionIfDuplicate) {
        this.preserveExtensionIfDuplicate = preserveExtensionIfDuplicate;
    }
}

