/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.file.namer.patternspan;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import lombok.Generated;
import org.anchoranalysis.core.functional.FunctionalList;
import org.anchoranalysis.core.system.path.FilePathToUnixStyleConverter;
import org.anchoranalysis.io.input.file.NamedFile;
import org.anchoranalysis.plugin.io.bean.file.namer.patternspan.ExtractVariableSpan;

class ExtractVariableSpanForList {
    public static List<NamedFile> listExtract(List<File> files, ExtractVariableSpan extractVariableSpan) {
        List listMaybeEmpty = FunctionalList.mapToListWithIndex(files, (file, index) -> ExtractVariableSpanForList.namedFileFor(extractVariableSpan, index, file));
        if (ExtractVariableSpanForList.hasAnyEmptyIdentifier(listMaybeEmpty)) {
            String prependStr = ExtractVariableSpanForList.extractLastComponent(extractVariableSpan.extractConstantElementBeforeSpanPortion());
            return ExtractVariableSpanForList.listPrepend(prependStr, listMaybeEmpty);
        }
        return listMaybeEmpty;
    }

    private static NamedFile namedFileFor(ExtractVariableSpan extractVariableSpan, int fileIndex, File file) {
        String identifier = extractVariableSpan.extractSpanPortionFor(fileIndex);
        identifier = identifier.trim();
        identifier = FilePathToUnixStyleConverter.toStringUnixStyle((String)identifier);
        return new NamedFile(identifier, file);
    }

    private static List<NamedFile> listPrepend(String prefix, List<NamedFile> list) {
        return ExtractVariableSpanForList.mapNamesOnList(list, (name, file) -> ExtractVariableSpanForList.prependName(prefix, name));
    }

    private static List<NamedFile> mapNamesOnList(Collection<NamedFile> collection, BiFunction<String, File, String> changeName) {
        return FunctionalList.mapToList(collection, df -> df.mapIdentifier(changeName));
    }

    private static String prependName(String prefix, String name) {
        return FilePathToUnixStyleConverter.toStringUnixStyle((String)(prefix + name)).trim();
    }

    private static boolean hasAnyEmptyIdentifier(List<NamedFile> list) {
        return list.stream().filter(file -> file.getIdentifier().isEmpty()).count() > 0L;
    }

    private static String extractLastComponent(String str) {
        if ((str = FilePathToUnixStyleConverter.toStringUnixStyle((String)str)).length() == 1) {
            return str;
        }
        String strMinusOne = str.substring(0, str.length() - 1);
        int finalIndex = strMinusOne.lastIndexOf(47);
        return str.substring(finalIndex + 1);
    }

    @Generated
    private ExtractVariableSpanForList() {
    }
}

