/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.file.namer.patternspan;

import com.owenfeehan.pathpatternfinder.Pattern;
import java.util.Optional;
import java.util.logging.Logger;
import lombok.Generated;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.index.range.IndexRangeNegative;
import org.anchoranalysis.plugin.io.bean.file.namer.patternspan.ExtractVariableSpan;
import org.anchoranalysis.plugin.io.bean.file.namer.patternspan.PatternElementOperations;

class SelectSpanToExtract {
    private static Logger log = Logger.getLogger(SelectSpanToExtract.class.getName());
    private Pattern pattern;
    private Optional<IndexRangeNegative> nameSubrange;

    public ExtractVariableSpan selectSpanToExtract(String elseName) {
        int numberVariableElements = PatternElementOperations.countVariableElements(this.pattern);
        return new ExtractVariableSpan(this.pattern, elseName, this.firstIndex(numberVariableElements), this.finalIndex(numberVariableElements));
    }

    private int firstIndex(int numberVariableElements) {
        if (this.nameSubrange.isPresent()) {
            try {
                int variableIndex = this.nameSubrange.get().correctedStartIndex(numberVariableElements);
                return this.findVariableElement(variableIndex);
            }
            catch (OperationFailedException e) {
                log.fine(e.getMessage());
                return PatternElementOperations.indexLeftMostVariableElement(this.pattern);
            }
        }
        return PatternElementOperations.indexLeftMostVariableElement(this.pattern);
    }

    private int finalIndex(int numberVariableElements) {
        if (this.nameSubrange.isPresent()) {
            try {
                int variableIndex = this.nameSubrange.get().correctedEndIndex(numberVariableElements);
                return this.findVariableElement(variableIndex);
            }
            catch (OperationFailedException e) {
                log.fine(e.getMessage());
                return this.finalIndexWithoutSubrange();
            }
        }
        return this.finalIndexWithoutSubrange();
    }

    private int finalIndexWithoutSubrange() {
        int rightmost = PatternElementOperations.indexRightMostVariableElement(this.pattern);
        if (this.doElementsAfterContainPeriod(rightmost)) {
            return rightmost;
        }
        return this.pattern.size() - 1;
    }

    private int findVariableElement(int variableIndex) {
        return PatternElementOperations.indexLeftMostVariableElement(this.pattern, variableIndex);
    }

    private boolean doElementsAfterContainPeriod(int index) {
        String remainingStr = PatternElementOperations.extractConstantElementsAfter(this.pattern, index);
        return remainingStr.indexOf(46) != -1;
    }

    @Generated
    public SelectSpanToExtract(Pattern pattern, Optional<IndexRangeNegative> nameSubrange) {
        this.pattern = pattern;
        this.nameSubrange = nameSubrange;
    }
}

