/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.file.path.prefixer;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.exception.BeanMisconfiguredException;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.io.output.bean.path.prefixer.IncrementingNumber;
import org.anchoranalysis.io.output.bean.path.prefixer.PathPrefixer;
import org.anchoranalysis.io.output.path.prefixer.DirectoryWithPrefix;
import org.anchoranalysis.io.output.path.prefixer.NamedPath;
import org.anchoranalysis.io.output.path.prefixer.PathPrefixerContext;
import org.anchoranalysis.io.output.path.prefixer.PathPrefixerException;

public class HomeSubdirectory
extends PathPrefixer {
    @BeanField
    private String directory = "anchorData";
    private IncrementingNumber delegate;

    public DirectoryWithPrefix outFilePrefix(NamedPath path, Optional<String> expName, PathPrefixerContext context) throws PathPrefixerException {
        try {
            this.initIfPossible();
        }
        catch (InitializeException e) {
            throw new PathPrefixerException((Throwable)e);
        }
        return this.delegate.outFilePrefix(path, expName, context);
    }

    public DirectoryWithPrefix rootDirectoryPrefix(Optional<String> expName, PathPrefixerContext context) throws PathPrefixerException {
        try {
            this.initIfPossible();
        }
        catch (InitializeException e) {
            throw new PathPrefixerException((Throwable)e);
        }
        return this.delegate.rootDirectoryPrefix(expName, context);
    }

    private void initIfPossible() throws InitializeException {
        if (this.delegate == null) {
            Path pathAnchorDirectory = this.createSubdirectoryIfNecessary(this.homeDirectory(), this.directory);
            this.delegate = new IncrementingNumber(pathAnchorDirectory.toString());
            try {
                this.delegate.localise(pathAnchorDirectory);
            }
            catch (BeanMisconfiguredException e) {
                throw new InitializeException((Throwable)e);
            }
        }
    }

    private Path homeDirectory() throws InitializeException {
        String string = System.getProperty("user.home");
        if (string == null || string.isEmpty()) {
            throw new InitializeException("No user.home environmental variable");
        }
        Path path = Paths.get(string, new String[0]);
        if (path.toFile().exists()) {
            return path;
        }
        throw new InitializeException(String.format("User home directory '%s' does not exist", string));
    }

    private Path createSubdirectoryIfNecessary(Path pathHomeDir, String relativePathSubdirectory) throws InitializeException {
        Path resolvedPath = pathHomeDir.resolve(relativePathSubdirectory);
        try {
            if (!resolvedPath.toFile().exists()) {
                Files.createDirectory(resolvedPath, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            throw new InitializeException((Throwable)e);
        }
        return resolvedPath;
    }

    @Generated
    public String getDirectory() {
        return this.directory;
    }

    @Generated
    public void setDirectory(String directory) {
        this.directory = directory;
    }
}

