/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.file.path.prefixer;

import java.nio.file.Path;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.shared.regex.RegEx;
import org.anchoranalysis.core.system.path.FilePathToUnixStyleConverter;
import org.anchoranalysis.io.output.bean.path.prefixer.PathPrefixerAvoidResolve;
import org.anchoranalysis.io.output.path.prefixer.DirectoryWithPrefix;
import org.anchoranalysis.io.output.path.prefixer.NamedPath;
import org.anchoranalysis.io.output.path.prefixer.PathPrefixerContext;
import org.anchoranalysis.io.output.path.prefixer.PathPrefixerException;

public class PathRegEx
extends PathPrefixerAvoidResolve {
    @BeanField
    private RegEx regEx;

    public DirectoryWithPrefix outFilePrefixFromPath(NamedPath path, Path root, PathPrefixerContext context) throws PathPrefixerException {
        String[] components = this.componentsFromPath(path.getPath());
        return PathRegEx.createPrefix(root, components);
    }

    private String[] componentsFromPath(Path pathIn) throws PathPrefixerException {
        String pathInForwardSlashes = FilePathToUnixStyleConverter.toStringUnixStyle((Path)pathIn);
        return (String[])this.regEx.match(pathInForwardSlashes).orElseThrow(() -> new PathPrefixerException(String.format("Cannot successfully match the %s against '%s'", this.regEx, pathInForwardSlashes)));
    }

    private static DirectoryWithPrefix createPrefix(Path outDirectoryPath, String[] components) {
        Path path = outDirectoryPath;
        for (int g = 0; g < components.length; ++g) {
            path = path.resolve(components[g]);
        }
        return new DirectoryWithPrefix(path);
    }

    @Generated
    public RegEx getRegEx() {
        return this.regEx;
    }

    @Generated
    public void setRegEx(RegEx regEx) {
        this.regEx = regEx;
    }
}

