/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.file.provider;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.exception.BeanDuplicateException;
import org.anchoranalysis.core.system.path.PathDifferenceException;
import org.anchoranalysis.io.input.bean.InputManagerParameters;
import org.anchoranalysis.io.input.bean.files.FilesProviderWithDirectory;
import org.anchoranalysis.io.input.bean.files.FilesProviderWithoutDirectory;
import org.anchoranalysis.io.input.file.FilesProviderException;
import org.anchoranalysis.plugin.io.input.path.RootedFilePathUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Rooted
extends FilesProviderWithoutDirectory {
    @BeanField
    private FilesProviderWithDirectory files;
    @BeanField
    private String rootName;
    @BeanField
    private boolean disableDebugMode = false;
    private static Log log = LogFactory.getLog(Rooted.class);

    public List<File> create(InputManagerParameters parameters) throws FilesProviderException {
        try {
            log.debug((Object)String.format("matchingFiles() old directory '%s'%n", this.files.getDirectoryAsPath(parameters.getInputContext())));
            Path directoryOriginal = this.files.getDirectoryAsPath(parameters.getInputContext());
            Path directoryNew = RootedFilePathUtilities.deriveRootedPath(directoryOriginal, this.rootName, parameters.isDebugModeActivated(), this.disableDebugMode);
            boolean directoryNewExists = directoryNew.toFile().exists();
            if (parameters.isDebugModeActivated() && !directoryNewExists) {
                directoryNew = RootedFilePathUtilities.deriveRootedPath(directoryOriginal, this.rootName, false, this.disableDebugMode);
                directoryNewExists = directoryNew.toFile().exists();
            }
            if (!directoryNewExists) {
                throw new FilesProviderException(String.format("Path %s' does not exist", directoryNew));
            }
            log.debug((Object)String.format("Setting new directory '%s'%n", directoryNew));
            return this.files.matchingFilesForDirectory(directoryNew, parameters);
        }
        catch (BeanDuplicateException | PathDifferenceException e) {
            throw new FilesProviderException(e);
        }
    }

    @Generated
    public FilesProviderWithDirectory getFiles() {
        return this.files;
    }

    @Generated
    public void setFiles(FilesProviderWithDirectory files) {
        this.files = files;
    }

    @Generated
    public String getRootName() {
        return this.rootName;
    }

    @Generated
    public void setRootName(String rootName) {
        this.rootName = rootName;
    }

    @Generated
    public boolean isDisableDebugMode() {
        return this.disableDebugMode;
    }

    @Generated
    public void setDisableDebugMode(boolean disableDebugMode) {
        this.disableDebugMode = disableDebugMode;
    }
}

