/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.input.channel;

import java.nio.file.Path;
import java.util.Optional;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.core.log.error.ErrorReporter;
import org.anchoranalysis.core.time.ExecutionTimeRecorder;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.stack.ImageMetadata;
import org.anchoranalysis.image.io.ImageIOException;
import org.anchoranalysis.image.io.bean.stack.reader.StackReader;
import org.anchoranalysis.image.io.channel.input.NamedChannelsInputPart;
import org.anchoranalysis.image.io.channel.map.NamedChannelsConcatenate;
import org.anchoranalysis.image.io.channel.map.NamedChannelsMap;
import org.anchoranalysis.image.io.channel.map.OpenedNamedChannels;
import org.anchoranalysis.image.io.stack.input.OpenedImageFile;
import org.anchoranalysis.io.input.path.DerivePathException;
import org.anchoranalysis.io.input.path.PathSupplier;
import org.anchoranalysis.plugin.io.bean.input.channel.AdditionalChannel;

class AppendPart
extends NamedChannelsInputPart {
    private final NamedChannelsInputPart toAppendTo;
    private final AdditionalChannel additionalChannel;
    private final StackReader stackReader;
    private final ExecutionTimeRecorder executionTimeRecorder;
    private OpenedImageFile openedFile;

    public AppendPart(NamedChannelsInputPart toAppendTo, String channelName, int channelIndex, PathSupplier filePath, StackReader stackReader, ExecutionTimeRecorder executionTimeRecorder) {
        this.toAppendTo = toAppendTo;
        this.additionalChannel = new AdditionalChannel(channelName, channelIndex, filePath);
        this.stackReader = stackReader;
        this.executionTimeRecorder = executionTimeRecorder;
    }

    public int numberSeries() throws ImageIOException {
        return this.toAppendTo.numberSeries();
    }

    public Dimensions dimensions(int stackIndexInSeries, Logger logger) throws ImageIOException {
        return this.toAppendTo.dimensions(stackIndexInSeries, logger);
    }

    public NamedChannelsMap createChannelsForSeries(int seriesIndex, Logger logger) throws ImageIOException {
        NamedChannelsMap existing = this.toAppendTo.createChannelsForSeries(seriesIndex, logger);
        this.openRasterIfNecessary();
        OpenedNamedChannels opened = new OpenedNamedChannels(this.openedFile, this.additionalChannel.createChannelMap(), seriesIndex);
        return new NamedChannelsConcatenate(new NamedChannelsMap[]{existing, opened});
    }

    public String identifier() {
        return this.toAppendTo.identifier();
    }

    public Optional<Path> pathForBinding() {
        return this.toAppendTo.pathForBinding();
    }

    public int numberChannels(Logger logger) throws ImageIOException {
        return this.toAppendTo.numberChannels(logger) + 1;
    }

    public int bitDepth(Logger logger) throws ImageIOException {
        return this.toAppendTo.bitDepth(logger);
    }

    public ImageMetadata metadata(int seriesIndex, Logger logger) throws ImageIOException {
        ImageMetadata existing = this.toAppendTo.metadata(seriesIndex, logger);
        return new ImageMetadata(existing.getDimensions(), existing.getNumberChannels() + 1, existing.getNumberFrames(), existing.getNumberSeries(), false, existing.getBitDepthPerChannel(), existing.getFileAttributes(), existing.getAcquisitionTime(), existing.getLocation(), existing.getPyramid());
    }

    public void close(ErrorReporter errorReporter) {
        if (this.openedFile != null) {
            try {
                this.openedFile.close();
            }
            catch (ImageIOException e) {
                errorReporter.recordError(AppendPart.class, (Throwable)e);
            }
        }
        this.toAppendTo.close(errorReporter);
    }

    private void openRasterIfNecessary() throws ImageIOException {
        try {
            Path filePathAdditional = this.additionalChannel.getFilePath();
            if (this.openedFile == null) {
                this.openedFile = this.stackReader.openFile(filePathAdditional, this.executionTimeRecorder);
            }
        }
        catch (DerivePathException e) {
            throw new ImageIOException("Failed to derive a file-path to open an image part.", (Throwable)e);
        }
    }
}

