/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.input.channel;

import java.nio.file.Path;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.core.log.error.ErrorReporter;
import org.anchoranalysis.core.time.ExecutionTimeRecorder;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.stack.ImageMetadata;
import org.anchoranalysis.image.io.ImageIOException;
import org.anchoranalysis.image.io.bean.channel.ChannelMapCreator;
import org.anchoranalysis.image.io.bean.stack.reader.StackReader;
import org.anchoranalysis.image.io.channel.input.ChannelMap;
import org.anchoranalysis.image.io.channel.input.NamedChannelsInputPart;
import org.anchoranalysis.image.io.channel.map.NamedChannelsMap;
import org.anchoranalysis.image.io.channel.map.OpenedNamedChannels;
import org.anchoranalysis.image.io.stack.input.OpenedImageFile;
import org.anchoranalysis.io.input.file.FileInput;

class MapPart
extends NamedChannelsInputPart {
    private final FileInput fileInput;
    private final StackReader stackReader;
    private final ChannelMapCreator channelMapCreator;
    private final boolean useLastSeriesIndexOnly;
    private final ExecutionTimeRecorder executionTimeRecorder;
    private OpenedImageFile openedFile = null;
    private ChannelMap channelMap = null;

    public Dimensions dimensions(int stackIndexInSeries, Logger logger) throws ImageIOException {
        return this.openedFile().dimensionsForSeries(stackIndexInSeries, logger);
    }

    public int numberSeries() throws ImageIOException {
        if (this.useLastSeriesIndexOnly) {
            return 1;
        }
        return this.openedFile().numberSeries();
    }

    public NamedChannelsMap createChannelsForSeries(int seriesIndex, Logger logger) throws ImageIOException {
        if (this.useLastSeriesIndexOnly) {
            seriesIndex = this.openedFile().numberSeries() - 1;
        }
        return new OpenedNamedChannels(this.openedFile(), this.channelMap(logger), seriesIndex);
    }

    public String identifier() {
        return this.fileInput.identifier();
    }

    public Optional<Path> pathForBinding() {
        return this.fileInput.pathForBinding();
    }

    public int numberChannels(Logger logger) throws ImageIOException {
        return this.openedFile().numberChannels(logger);
    }

    public int bitDepth(Logger logger) throws ImageIOException {
        return this.openedFile().bitDepth(logger);
    }

    public void close(ErrorReporter errorReporter) {
        if (this.openedFile != null) {
            try {
                this.openedFile.close();
            }
            catch (ImageIOException e) {
                errorReporter.recordError(MapPart.class, (Throwable)e);
            }
        }
        this.fileInput.close(errorReporter);
    }

    public ImageMetadata metadata(int seriesIndex, Logger logger) throws ImageIOException {
        return this.openedFile().metadata(seriesIndex, logger);
    }

    public String toString() {
        return this.fileInput.toString();
    }

    private ChannelMap channelMap(Logger logger) throws ImageIOException {
        if (this.channelMap == null) {
            try {
                this.channelMap = this.channelMapCreator.create(this.openedFile, logger);
            }
            catch (CreateException e) {
                throw new ImageIOException("Failed to create channel-map", (Throwable)e);
            }
        }
        return this.channelMap;
    }

    private OpenedImageFile openedFile() throws ImageIOException {
        if (this.openedFile == null) {
            Path path = (Path)this.fileInput.pathForBinding().orElseThrow(() -> new ImageIOException("A binding-path is needed in the delegate."));
            this.openedFile = this.stackReader.openFile(path, this.executionTimeRecorder);
        }
        return this.openedFile;
    }

    @Generated
    public MapPart(FileInput fileInput, StackReader stackReader, ChannelMapCreator channelMapCreator, boolean useLastSeriesIndexOnly, ExecutionTimeRecorder executionTimeRecorder) {
        this.fileInput = fileInput;
        this.stackReader = stackReader;
        this.channelMapCreator = channelMapCreator;
        this.useLastSeriesIndexOnly = useLastSeriesIndexOnly;
        this.executionTimeRecorder = executionTimeRecorder;
    }
}

