/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.input.channel;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import lombok.Generated;
import org.anchoranalysis.bean.NamedBean;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.OptionalBean;
import org.anchoranalysis.core.cache.CachedSupplier;
import org.anchoranalysis.core.functional.FunctionalList;
import org.anchoranalysis.core.time.ExecutionTimeRecorder;
import org.anchoranalysis.image.io.channel.input.NamedChannelsInputPart;
import org.anchoranalysis.io.input.InputReadFailedException;
import org.anchoranalysis.io.input.InputsWithDirectory;
import org.anchoranalysis.io.input.bean.InputManager;
import org.anchoranalysis.io.input.bean.InputManagerParameters;
import org.anchoranalysis.io.input.bean.path.DerivePath;
import org.anchoranalysis.io.input.path.DerivePathException;
import org.anchoranalysis.io.input.path.PathSupplier;
import org.anchoranalysis.plugin.io.bean.input.channel.AppendPart;
import org.anchoranalysis.plugin.io.bean.input.channel.NamedChannelsBase;

public class NamedChannelsAppend
extends NamedChannelsBase {
    @BeanField
    private InputManager<NamedChannelsInputPart> input;
    @BeanField
    @OptionalBean
    private List<NamedBean<DerivePath>> listAppend;
    @BeanField
    private boolean forceEagerEvaluation = false;
    @BeanField
    private boolean ignoreFileNotFoundAppend = false;
    @BeanField
    private boolean skipMissingChannels = false;

    public InputsWithDirectory<NamedChannelsInputPart> inputs(InputManagerParameters parameters) throws InputReadFailedException {
        InputsWithDirectory inputs = this.input.inputs(parameters);
        Iterator iterator = inputs.iterator();
        ArrayList<NamedChannelsInputPart> listTemp = new ArrayList<NamedChannelsInputPart>();
        while (iterator.hasNext()) {
            listTemp.add((NamedChannelsInputPart)iterator.next());
        }
        List<NamedChannelsInputPart> outList = this.createOutList(listTemp, parameters.isDebugModeActivated(), parameters.getExecutionTimeRecorder());
        return inputs.withInputs(outList);
    }

    private List<NamedChannelsInputPart> createOutList(List<NamedChannelsInputPart> listTemp, boolean debugMode, ExecutionTimeRecorder executionTimeRecorder) throws InputReadFailedException {
        try {
            return FunctionalList.mapToListOptional(listTemp, DerivePathException.class, channels -> this.maybeAppend((NamedChannelsInputPart)channels, debugMode, executionTimeRecorder));
        }
        catch (DerivePathException e) {
            throw new InputReadFailedException((Throwable)e);
        }
    }

    private Optional<NamedChannelsInputPart> maybeAppend(NamedChannelsInputPart channels, boolean debugMode, ExecutionTimeRecorder executionTimeRecorder) throws DerivePathException {
        if (this.ignoreFileNotFoundAppend) {
            try {
                return Optional.of(this.append(channels, debugMode, executionTimeRecorder));
            }
            catch (DerivePathException e) {
                return Optional.empty();
            }
        }
        return Optional.of(this.append(channels, debugMode, executionTimeRecorder));
    }

    private NamedChannelsInputPart append(NamedChannelsInputPart input, boolean debugMode, ExecutionTimeRecorder executionTimeRecorder) throws DerivePathException {
        NamedChannelsInputPart out = input;
        if (this.listAppend == null) {
            return out;
        }
        for (NamedBean<DerivePath> namedPath : this.listAppend) {
            Path path;
            PathSupplier outPath = NamedChannelsAppend.cachedOutPathFor((DerivePath)namedPath.getValue(), () -> ((NamedChannelsInputPart)input).pathForBinding(), debugMode);
            if (this.forceEagerEvaluation && !this.skipMissingChannels && !(path = outPath.get()).toFile().exists()) {
                throw new DerivePathException(String.format("Append path: %s does not exist", path));
            }
            out = new AppendPart(out, namedPath.getName(), 0, outPath, this.getStackReader(), executionTimeRecorder);
        }
        return out;
    }

    private static PathSupplier cachedOutPathFor(DerivePath outputPathGenerator, Supplier<Optional<Path>> pathInput, boolean debugMode) {
        return NamedChannelsAppend.cachePathSupplier(() -> outputPathGenerator.deriveFrom(pathInput, debugMode).toAbsolutePath().normalize());
    }

    private static PathSupplier cachePathSupplier(PathSupplier supplier) {
        return () -> ((CachedSupplier)CachedSupplier.cacheChecked(() -> ((PathSupplier)supplier).get())).get();
    }

    @Generated
    public InputManager<NamedChannelsInputPart> getInput() {
        return this.input;
    }

    @Generated
    public void setInput(InputManager<NamedChannelsInputPart> input) {
        this.input = input;
    }

    @Generated
    public List<NamedBean<DerivePath>> getListAppend() {
        return this.listAppend;
    }

    @Generated
    public void setListAppend(List<NamedBean<DerivePath>> listAppend) {
        this.listAppend = listAppend;
    }

    @Generated
    public boolean isForceEagerEvaluation() {
        return this.forceEagerEvaluation;
    }

    @Generated
    public void setForceEagerEvaluation(boolean forceEagerEvaluation) {
        this.forceEagerEvaluation = forceEagerEvaluation;
    }

    @Generated
    public boolean isIgnoreFileNotFoundAppend() {
        return this.ignoreFileNotFoundAppend;
    }

    @Generated
    public void setIgnoreFileNotFoundAppend(boolean ignoreFileNotFoundAppend) {
        this.ignoreFileNotFoundAppend = ignoreFileNotFoundAppend;
    }

    @Generated
    public boolean isSkipMissingChannels() {
        return this.skipMissingChannels;
    }

    @Generated
    public void setSkipMissingChannels(boolean skipMissingChannels) {
        this.skipMissingChannels = skipMissingChannels;
    }
}

