/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.input.files;

import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.DefaultInstance;
import org.anchoranalysis.core.functional.FunctionalList;
import org.anchoranalysis.core.functional.OptionalUtilities;
import org.anchoranalysis.core.functional.checked.CheckedSupplier;
import org.anchoranalysis.io.input.InputContextParameters;
import org.anchoranalysis.io.input.InputFromManager;
import org.anchoranalysis.io.input.InputReadFailedException;
import org.anchoranalysis.io.input.InputsWithDirectory;
import org.anchoranalysis.io.input.bean.InputManager;
import org.anchoranalysis.io.input.bean.InputManagerParameters;
import org.anchoranalysis.io.input.bean.files.FilesProvider;
import org.anchoranalysis.io.input.bean.namer.FileNamer;
import org.anchoranalysis.io.input.file.FileNamerContext;
import org.anchoranalysis.io.input.file.FilesProviderException;
import org.anchoranalysis.io.input.file.NamedFile;

public abstract class NamedFilesBase<T extends InputFromManager>
extends InputManager<T> {
    @BeanField
    @DefaultInstance
    private FileNamer namer;

    protected InputsWithDirectory<T> createInputsFromFiles(FilesProvider files, InputManagerParameters parameters, Function<NamedFile, T> mapToInput) throws InputReadFailedException {
        try {
            List filesCreated = files.create(parameters);
            Optional<Path> inputDirectory = NamedFilesBase.inputDirectory(files, parameters.getInputContext());
            FileNamerContext context = new FileNamerContext(inputDirectory, parameters.getInputContext().isRelativeForIdentifier(), parameters.getInputContext().getIdentifierSubrange(), parameters.getLogger());
            return new InputsWithDirectory(this.createInputs(filesCreated, mapToInput, context), inputDirectory);
        }
        catch (FilesProviderException e) {
            throw new InputReadFailedException("Cannot find files", (Throwable)e);
        }
    }

    private List<T> createInputs(List<File> filesCreated, Function<NamedFile, T> mapToInput, FileNamerContext context) throws InputReadFailedException {
        return FunctionalList.mapToList((Collection)this.namer.deriveNameUnique(filesCreated, context), mapToInput);
    }

    private static Optional<Path> inputDirectory(FilesProvider files, InputContextParameters context) throws FilesProviderException {
        return OptionalUtilities.orElseGetFlat((Optional)context.getInputDirectory(), (CheckedSupplier[])new CheckedSupplier[]{() -> files.rootDirectory(context)});
    }

    @Generated
    public NamedFilesBase() {
    }

    @Generated
    public NamedFilesBase(FileNamer namer) {
        this.namer = namer;
    }

    @Generated
    public FileNamer getNamer() {
        return this.namer;
    }

    @Generated
    public void setNamer(FileNamer namer) {
        this.namer = namer;
    }
}

