/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.input.files.provider;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.io.input.bean.InputManagerParameters;
import org.anchoranalysis.io.input.bean.files.FilesProviderWithDirectoryString;
import org.anchoranalysis.io.input.file.FilesProviderException;
import org.anchoranalysis.plugin.io.bean.input.files.provider.WalkToDepth;

public class DirectoryDepth
extends FilesProviderWithDirectoryString {
    @BeanField
    private int exactDepth = 0;

    public List<File> matchingFilesForDirectory(Path directory, InputManagerParameters parameters) throws FilesProviderException {
        String[] filesDirectory = directory.toFile().list();
        if (filesDirectory == null) {
            throw new FilesProviderException(String.format("Path %s is not valid. Cannot enumerate directory.", directory));
        }
        WalkToDepth walkTo = new WalkToDepth(this.exactDepth);
        try {
            return walkTo.findDirs(directory.toFile());
        }
        catch (IOException e) {
            throw new FilesProviderException((Throwable)e);
        }
    }

    @Generated
    public int getExactDepth() {
        return this.exactDepth;
    }

    @Generated
    public void setExactDepth(int exactDepth) {
        this.exactDepth = exactDepth;
    }
}

