/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.metadata.header;

import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.bmp.BmpHeaderDirectory;
import java.util.Optional;
import org.anchoranalysis.core.format.ImageFileFormat;
import org.anchoranalysis.image.core.stack.ImageFileAttributes;
import org.anchoranalysis.image.core.stack.ImageMetadata;
import org.anchoranalysis.image.io.ImageIOException;
import org.anchoranalysis.io.bioformats.metadata.ExtentReader;
import org.anchoranalysis.io.bioformats.metadata.MetadataReader;
import org.anchoranalysis.plugin.io.bean.metadata.header.HeaderFormat;
import org.anchoranalysis.plugin.io.bean.metadata.header.MetadataFactory;
import org.anchoranalysis.spatial.box.Extent;

public class BMP
extends HeaderFormat {
    @Override
    protected ImageFileFormat format() {
        return ImageFileFormat.BMP;
    }

    @Override
    protected Optional<ImageMetadata> populateFromMetadata(Metadata metadata, ImageFileAttributes attributes) throws ImageIOException {
        Directory directory = metadata.getFirstDirectoryOfType(BmpHeaderDirectory.class);
        if (directory == null) {
            return Optional.empty();
        }
        Optional extent = ExtentReader.read((Directory)directory, (int)2, (int)1);
        if (!extent.isPresent()) {
            return Optional.empty();
        }
        Optional bitDepth = MetadataReader.readInt((Directory)directory, (int)4);
        if (!bitDepth.isPresent()) {
            return Optional.empty();
        }
        int pixelDepth = BMP.inferPixelDepth((Integer)bitDepth.get());
        return BMP.createMetadata((Extent)extent.get(), pixelDepth, 8, attributes);
    }

    private static int inferPixelDepth(int bitDepth) throws ImageIOException {
        return switch (bitDepth) {
            case 1, 2, 3, 4, 5, 6, 7, 8 -> 1;
            case 16 -> 2;
            case 24 -> 3;
            case 32 -> 4;
            default -> throw new ImageIOException(String.format("Unrecognised bitsPerPixel of %d", bitDepth));
        };
    }

    private static Optional<ImageMetadata> createMetadata(Extent extent, int numberChannels, int pixelDepth, ImageFileAttributes timestamps) {
        return Optional.of(MetadataFactory.createMetadata(extent, numberChannels, pixelDepth, timestamps));
    }
}

