/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.metadata.header;

import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.jpeg.JpegDirectory;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.core.functional.OptionalUtilities;
import org.anchoranalysis.core.functional.checked.CheckedSupplier;
import org.anchoranalysis.image.core.dimensions.OrientationChange;
import org.anchoranalysis.image.io.ImageIOException;
import org.anchoranalysis.io.bioformats.metadata.ExtentReader;
import org.anchoranalysis.spatial.box.Extent;

class ExtentFromMetadata {
    public static Optional<Extent> inferFromEXIFOr(Metadata metadata, Optional<OrientationChange> orientation) throws ImageIOException {
        Optional extent = OptionalUtilities.orFlatSupplier((CheckedSupplier[])new CheckedSupplier[]{() -> ExtentFromMetadata.extentFromExif(metadata), () -> ExtentFromMetadata.extentFromJPEG(metadata)});
        if (extent.isPresent()) {
            if (orientation.isPresent()) {
                return Optional.of(orientation.get().extent((Extent)extent.get()));
            }
            return extent;
        }
        return Optional.empty();
    }

    private static Optional<Extent> extentFromExif(Metadata metadata) throws ImageIOException {
        return ExtentReader.read((Metadata)metadata, ExifIFD0Directory.class, (int)256, (int)257);
    }

    private static Optional<Extent> extentFromJPEG(Metadata metadata) throws ImageIOException {
        return ExtentReader.read((Metadata)metadata, JpegDirectory.class, (int)3, (int)1);
    }

    @Generated
    private ExtentFromMetadata() {
    }
}

