/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.metadata.header;

import com.drew.imaging.ImageMetadataReader;
import com.drew.imaging.ImageProcessingException;
import com.drew.metadata.Metadata;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import org.anchoranalysis.bean.AnchorBean;
import org.anchoranalysis.core.format.ImageFileFormat;
import org.anchoranalysis.image.core.stack.ImageFileAttributes;
import org.anchoranalysis.image.core.stack.ImageMetadata;
import org.anchoranalysis.image.io.ImageIOException;

public abstract class HeaderFormat
extends AnchorBean<HeaderFormat> {
    public Optional<ImageMetadata> populateFrom(Path path) throws ImageIOException {
        try {
            if (this.format().matches(path)) {
                Metadata metadata = ImageMetadataReader.readMetadata((File)path.toFile());
                if (metadata == null) {
                    return Optional.empty();
                }
                ImageFileAttributes attributes = ImageFileAttributes.fromPath((Path)path);
                return this.populateFromMetadata(metadata, attributes);
            }
            return Optional.empty();
        }
        catch (ImageProcessingException | IOException e) {
            throw new ImageIOException("Failed to establish image-metadata", e);
        }
    }

    protected abstract ImageFileFormat format();

    protected abstract Optional<ImageMetadata> populateFromMetadata(Metadata var1, ImageFileAttributes var2) throws ImageIOException;
}

