/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.metadata.header;

import com.drew.metadata.Metadata;
import com.drew.metadata.jpeg.JpegDirectory;
import java.util.Optional;
import org.anchoranalysis.core.format.ImageFileFormat;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.stack.ImageFileAttributes;
import org.anchoranalysis.image.core.stack.ImageMetadata;
import org.anchoranalysis.image.io.ImageIOException;
import org.anchoranalysis.io.bioformats.metadata.AcquisitionDateReader;
import org.anchoranalysis.io.bioformats.metadata.LocationReader;
import org.anchoranalysis.io.bioformats.metadata.MetadataReader;
import org.anchoranalysis.io.bioformats.metadata.OrientationReader;
import org.anchoranalysis.plugin.io.bean.metadata.header.ExtentFromMetadata;
import org.anchoranalysis.plugin.io.bean.metadata.header.HeaderFormat;

public class JPEG
extends HeaderFormat {
    @Override
    protected ImageFileFormat format() {
        return ImageFileFormat.JPEG;
    }

    @Override
    protected Optional<ImageMetadata> populateFromMetadata(Metadata metadata, ImageFileAttributes attributes) throws ImageIOException {
        Optional orientation = OrientationReader.determineOrientationCorrection((Metadata)metadata);
        Optional<Dimensions> dimensions = ExtentFromMetadata.inferFromEXIFOr(metadata, orientation).map(Dimensions::new);
        if (dimensions.isPresent()) {
            return JPEG.inferRemainingAttributes(metadata, dimensions.get(), attributes);
        }
        return Optional.empty();
    }

    private static Optional<ImageMetadata> inferRemainingAttributes(Metadata metadata, Dimensions dimensions, ImageFileAttributes timestamps) {
        Optional<Integer> numberChannels = JPEG.inferNumberChannels(metadata);
        if (!numberChannels.isPresent()) {
            return Optional.empty();
        }
        Optional<Integer> bitDepth = JPEG.inferBitDepth(metadata);
        if (!bitDepth.isPresent()) {
            return Optional.empty();
        }
        Optional acqusitionDate = AcquisitionDateReader.readAcquisitionDate((Metadata)metadata);
        Optional location = LocationReader.readLocation((Metadata)metadata);
        boolean rgb = numberChannels.get() == 3;
        return Optional.of(new ImageMetadata(dimensions, numberChannels.get().intValue(), 1, 1, rgb, bitDepth.get().intValue(), timestamps, acqusitionDate, location, Optional.empty()));
    }

    private static Optional<Integer> inferNumberChannels(Metadata metadata) {
        return MetadataReader.readInt((Metadata)metadata, JpegDirectory.class, (int)5);
    }

    private static Optional<Integer> inferBitDepth(Metadata metadata) {
        return MetadataReader.readInt((Metadata)metadata, JpegDirectory.class, (int)0);
    }
}

