/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.path.derive;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.shared.regex.RegEx;
import org.anchoranalysis.bean.shared.regex.RegExSimple;
import org.anchoranalysis.io.input.bean.path.DerivePath;
import org.anchoranalysis.io.input.path.DerivePathException;
import org.anchoranalysis.plugin.io.bean.path.derive.ConvertPathUtilities;

public class InsertRegExGroups
extends DerivePath {
    @BeanField
    private RegEx regEx;
    @BeanField
    private String outPath = "";

    public Path deriveFrom(Path source, boolean debugMode) throws DerivePathException {
        String[] matches = this.match(source);
        String outStr = this.outPath;
        for (int groupIndex = matches.length; groupIndex > 0; --groupIndex) {
            outStr = outStr.replaceAll("\\$" + Integer.toString(groupIndex), matches[groupIndex - 1]);
        }
        return Paths.get(outStr, new String[0]);
    }

    private String[] match(Path pathIn) throws DerivePathException {
        String pathInStr = ConvertPathUtilities.convertBackslashes(pathIn);
        Optional matches = this.regEx.match(pathInStr);
        if (!matches.isPresent()) {
            throw new DerivePathException(String.format("RegEx string '%s' does not match '%s'", this.regEx, pathInStr));
        }
        return (String[])matches.get();
    }

    public void setRegExString(String regEx) {
        this.regEx = new RegExSimple(regEx);
    }

    public void setRegEx(RegEx regEx) {
        this.regEx = regEx;
    }

    @Generated
    public InsertRegExGroups() {
    }

    @Generated
    public InsertRegExGroups(RegEx regEx, String outPath) {
        this.regEx = regEx;
        this.outPath = outPath;
    }

    @Generated
    public RegEx getRegEx() {
        return this.regEx;
    }

    @Generated
    public String getOutPath() {
        return this.outPath;
    }

    @Generated
    public void setOutPath(String outPath) {
        this.outPath = outPath;
    }
}

