/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.path.derive;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.StringJoiner;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.shared.regex.RegEx;
import org.anchoranalysis.core.system.path.FilePathToUnixStyleConverter;
import org.anchoranalysis.io.input.bean.path.DerivePath;
import org.anchoranalysis.io.input.path.DerivePathException;

public class JoinRegExGroups
extends DerivePath {
    @BeanField
    private RegEx regEx;

    public Path deriveFrom(Path source, boolean debugMode) throws DerivePathException {
        String pathInStr = FilePathToUnixStyleConverter.toStringUnixStyle((Path)source);
        String[] components = (String[])this.regEx.match(pathInStr).orElseThrow(() -> new DerivePathException(String.format("RegEx string '%s' does not match '%s'", this.regEx, pathInStr)));
        return Paths.get(this.createOutString(components), new String[0]);
    }

    private String createOutString(String[] components) {
        StringJoiner sj = new StringJoiner("/");
        for (int i = 0; i < components.length; ++i) {
            sj.add(components[i]);
        }
        return sj.toString();
    }

    @Generated
    public RegEx getRegEx() {
        return this.regEx;
    }

    @Generated
    public void setRegEx(RegEx regEx) {
        this.regEx = regEx;
    }
}

