/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.stack.reader;

import java.nio.file.Path;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.primitive.StringSet;
import org.anchoranalysis.core.collection.StringSetTrie;
import org.anchoranalysis.core.system.path.ExtensionUtilities;
import org.anchoranalysis.core.time.ExecutionTimeRecorder;
import org.anchoranalysis.image.io.ImageIOException;
import org.anchoranalysis.image.io.bean.stack.reader.StackReader;
import org.anchoranalysis.image.io.stack.input.OpenedImageFile;

public class BranchExtension
extends StackReader {
    @BeanField
    private StringSet extensions;
    @BeanField
    private StackReader readerMatching;
    @BeanField
    private StackReader readerNotMatching;
    private StringSetTrie extensionsLowercase;

    public OpenedImageFile openFile(Path path, ExecutionTimeRecorder executionTimeRecorder) throws ImageIOException {
        if (this.doesPathHaveExtension(path)) {
            return this.readerMatching.openFile(path, executionTimeRecorder);
        }
        return this.readerNotMatching.openFile(path, executionTimeRecorder);
    }

    private void createLowercaseExtensionsIfNecessary() {
        if (this.extensionsLowercase == null) {
            this.extensionsLowercase = new StringSetTrie(this.extensions.stream().map(String::toLowerCase));
        }
    }

    private boolean doesPathHaveExtension(Path path) {
        this.createLowercaseExtensionsIfNecessary();
        Optional extension = ExtensionUtilities.extractExtension((String)path.toString().toLowerCase());
        if (extension.isPresent()) {
            return this.extensionsLowercase.contains((String)extension.get());
        }
        return false;
    }

    @Generated
    public StringSet getExtensions() {
        return this.extensions;
    }

    @Generated
    public void setExtensions(StringSet extensions) {
        this.extensions = extensions;
    }

    @Generated
    public StackReader getReaderMatching() {
        return this.readerMatching;
    }

    @Generated
    public void setReaderMatching(StackReader readerMatching) {
        this.readerMatching = readerMatching;
    }

    @Generated
    public StackReader getReaderNotMatching() {
        return this.readerNotMatching;
    }

    @Generated
    public void setReaderNotMatching(StackReader readerNotMatching) {
        this.readerNotMatching = readerNotMatching;
    }
}

