/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.stack.reader;

import java.io.File;
import java.nio.file.Path;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.format.NonImageFileFormat;
import org.anchoranalysis.core.time.ExecutionTimeRecorder;
import org.anchoranalysis.image.core.dimensions.Resolution;
import org.anchoranalysis.image.io.ImageIOException;
import org.anchoranalysis.image.io.bean.stack.reader.StackReader;
import org.anchoranalysis.image.io.stack.input.OpenedImageFile;
import org.anchoranalysis.plugin.io.bean.stack.reader.OpenedRasterAlterDimensions;
import org.anchoranalysis.plugin.io.xml.ResolutionAsXML;

public class ReadVoxelExtentXml
extends StackReader {
    @BeanField
    private StackReader stackReader;
    @BeanField
    private boolean acceptNoResolution = true;

    public static Optional<Resolution> readMetadata(Path filePath, boolean acceptNoResolution) throws ImageIOException {
        File fileMetadata = NonImageFileFormat.XML.buildPath(filePath).toFile();
        if (fileMetadata.exists()) {
            return Optional.of(ResolutionAsXML.readResolutionXml(fileMetadata));
        }
        if (!acceptNoResolution) {
            throw new ImageIOException(String.format("Resolution metadata is required for '%s'", filePath));
        }
        return Optional.empty();
    }

    public OpenedImageFile openFile(Path path, ExecutionTimeRecorder executionTimeRecorder) throws ImageIOException {
        OpenedImageFile delegate = this.stackReader.openFile(path, executionTimeRecorder);
        Optional<Resolution> resolutionToAssign = ReadVoxelExtentXml.readMetadata(path, this.acceptNoResolution);
        return new OpenedRasterAlterDimensions(delegate, existingResolution -> resolutionToAssign);
    }

    @Generated
    public StackReader getStackReader() {
        return this.stackReader;
    }

    @Generated
    public void setStackReader(StackReader stackReader) {
        this.stackReader = stackReader;
    }

    @Generated
    public boolean isAcceptNoResolution() {
        return this.acceptNoResolution;
    }

    @Generated
    public void setAcceptNoResolution(boolean acceptNoResolution) {
        this.acceptNoResolution = acceptNoResolution;
    }
}

