/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.stack.reader;

import java.nio.file.Path;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.format.ImageFileFormat;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.core.time.ExecutionTimeRecorder;
import org.anchoranalysis.image.core.dimensions.OrientationChange;
import org.anchoranalysis.image.io.ImageIOException;
import org.anchoranalysis.image.io.bean.stack.reader.StackReaderOrientationCorrection;
import org.anchoranalysis.image.io.stack.CalculateOrientationChange;
import org.anchoranalysis.image.io.stack.input.OpenedImageFile;
import org.anchoranalysis.io.bioformats.metadata.OrientationReader;

public class RotateImageToMatchEXIFOrientation
extends StackReaderOrientationCorrection {
    @BeanField
    private StackReaderOrientationCorrection reader;

    public OpenedImageFile openFile(Path path, ExecutionTimeRecorder executionTimeRecorder) throws ImageIOException {
        CalculateOrientationChange calculateOrientationChange = logger -> (OrientationChange)executionTimeRecorder.recordExecutionTime("Calculating orientation change", () -> RotateImageToMatchEXIFOrientation.inferNeededOrientationChange(path, logger));
        return this.openFile(path, calculateOrientationChange, executionTimeRecorder);
    }

    public OpenedImageFile openFile(Path path, CalculateOrientationChange orientationCorrection, ExecutionTimeRecorder executionTimeRecorder) throws ImageIOException {
        return this.reader.openFile(path, orientationCorrection, executionTimeRecorder);
    }

    private static OrientationChange inferNeededOrientationChange(Path path, Logger logger) throws ImageIOException {
        try {
            if (ImageFileFormat.JPEG.matches(path) || ImageFileFormat.TIFF.matches(path)) {
                OrientationChange change = OrientationReader.determineOrientationCorrection((Path)path).orElse(OrientationChange.KEEP_UNCHANGED);
                if (change != OrientationChange.KEEP_UNCHANGED) {
                    logger.messageLogger().log("Reoriented image from EXIF tag: " + change.toString());
                }
                return change;
            }
            return OrientationChange.KEEP_UNCHANGED;
        }
        catch (Exception e) {
            logger.errorReporter().recordError(RotateImageToMatchEXIFOrientation.class, "Avoiding any orientation change, as cannot determine orientation from EXIF metadata due to following error.", (Throwable)e);
            return OrientationChange.KEEP_UNCHANGED;
        }
    }

    @Generated
    public RotateImageToMatchEXIFOrientation() {
    }

    @Generated
    public RotateImageToMatchEXIFOrientation(StackReaderOrientationCorrection reader) {
        this.reader = reader;
    }

    @Generated
    public StackReaderOrientationCorrection getReader() {
        return this.reader;
    }

    @Generated
    public void setReader(StackReaderOrientationCorrection reader) {
        this.reader = reader;
    }
}

