/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.stack.writer;

import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.format.ImageFileFormat;
import org.anchoranalysis.core.functional.CheckedStream;
import org.anchoranalysis.image.io.ImageIOException;
import org.anchoranalysis.image.io.bean.stack.writer.StackWriter;
import org.anchoranalysis.image.io.stack.output.StackWriteOptions;
import org.anchoranalysis.plugin.io.bean.stack.writer.StackWriterDelegateBase;

public class BranchSuggestedFormat
extends StackWriterDelegateBase {
    @BeanField
    private List<StackWriter> writersIfSuggested;
    @BeanField
    private StackWriter writerIfNoSuggestion;

    @Override
    protected StackWriter selectDelegate(StackWriteOptions writeOptions) throws ImageIOException {
        Optional format = writeOptions.getSuggestedFormatToWrite();
        if (format.isPresent()) {
            String extension = ((ImageFileFormat)format.get()).getDefaultExtension();
            return this.writerForExtension(extension, writeOptions).orElseThrow(() -> new ImageIOException("No stack-writer is present in 'writers' that matches " + extension));
        }
        return this.writerIfNoSuggestion;
    }

    private Optional<StackWriter> writerForExtension(String extension, StackWriteOptions writeOptions) throws ImageIOException {
        return CheckedStream.filter(this.writersIfSuggested.stream(), ImageIOException.class, writer -> writer.fileFormat(writeOptions).matchesIdentifier(extension)).findFirst();
    }

    @Generated
    public List<StackWriter> getWritersIfSuggested() {
        return this.writersIfSuggested;
    }

    @Generated
    public void setWritersIfSuggested(List<StackWriter> writersIfSuggested) {
        this.writersIfSuggested = writersIfSuggested;
    }

    @Generated
    public StackWriter getWriterIfNoSuggestion() {
        return this.writerIfNoSuggestion;
    }

    @Generated
    public void setWriterIfNoSuggestion(StackWriter writerIfNoSuggestion) {
        this.writerIfNoSuggestion = writerIfNoSuggestion;
    }
}

