/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.stack.writer;

import java.nio.file.Path;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.format.ImageFileFormat;
import org.anchoranalysis.core.format.NonImageFileFormat;
import org.anchoranalysis.image.core.dimensions.Resolution;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.io.ImageIOException;
import org.anchoranalysis.image.io.bean.stack.writer.StackWriter;
import org.anchoranalysis.image.io.stack.output.StackWriteOptions;
import org.anchoranalysis.plugin.io.xml.ResolutionAsXML;

public class WriteResolutionXml
extends StackWriter {
    @BeanField
    private StackWriter writer;

    public ImageFileFormat fileFormat(StackWriteOptions writeOptions) throws ImageIOException {
        return this.writer.fileFormat(writeOptions);
    }

    public void writeStack(Stack stack, Path filePath, StackWriteOptions options) throws ImageIOException {
        this.writer.writeStack(stack, filePath, options);
        this.writeResolutionXml(filePath, stack.resolution());
    }

    private void writeResolutionXml(Path filePath, Optional<Resolution> resolution) throws ImageIOException {
        if (resolution.isPresent()) {
            Path pathOut = NonImageFileFormat.XML.buildPath(filePath);
            ResolutionAsXML.writeResolutionXML(resolution.get(), pathOut);
        }
    }

    @Generated
    public StackWriter getWriter() {
        return this.writer;
    }

    @Generated
    public void setWriter(StackWriter writer) {
        this.writer = writer;
    }
}

