/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.summarizer;

import java.util.List;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.plugin.io.bean.summarizer.Summarizer;

public class SummarizerAggregate<T>
extends Summarizer<T> {
    private static final String BULLET_POINT = "-> ";
    @BeanField
    private List<Summarizer<T>> list;
    @BeanField
    private boolean avoidBulletOnFirst = false;

    @Override
    public void add(T element) throws OperationFailedException {
        for (Summarizer<T> summarizer : this.list) {
            summarizer.add(element);
        }
    }

    @Override
    public String describe() throws OperationFailedException {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.list.size(); ++i) {
            if (i != 0) {
                builder.append(System.lineSeparator());
            }
            if (!this.avoidBulletOnFirst || i != 0) {
                builder.append(BULLET_POINT);
            }
            Summarizer<T> element = this.list.get(i);
            builder.append(element.describe());
        }
        return builder.toString();
    }

    @Override
    public boolean requiresImageMetadata() throws OperationFailedException {
        for (Summarizer<T> summarizer : this.list) {
            if (!summarizer.requiresImageMetadata()) continue;
            return summarizer.requiresImageMetadata();
        }
        return false;
    }

    @Generated
    public List<Summarizer<T>> getList() {
        return this.list;
    }

    @Generated
    public void setList(List<Summarizer<T>> list) {
        this.list = list;
    }

    @Generated
    public boolean isAvoidBulletOnFirst() {
        return this.avoidBulletOnFirst;
    }

    @Generated
    public void setAvoidBulletOnFirst(boolean avoidBulletOnFirst) {
        this.avoidBulletOnFirst = avoidBulletOnFirst;
    }
}

