/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.task;

import java.util.ArrayList;
import java.util.List;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.value.TypedValue;
import org.anchoranalysis.io.generator.tabular.CSVWriter;
import org.anchoranalysis.io.input.csv.CSVReaderException;
import org.anchoranalysis.io.input.csv.ReadByLine;
import org.anchoranalysis.plugin.io.bean.task.TypedValueUtilities;

class AddWithName {
    private CSVWriter writer;
    private boolean firstLineHeaders;
    private String name;

    public AddWithName(CSVWriter writer, boolean firstLineHeaders, String name) {
        this.writer = writer;
        this.firstLineHeaders = firstLineHeaders;
        this.name = name;
    }

    public void addNonTransposed(ReadByLine readByLine) throws CSVReaderException {
        readByLine.read(this::addNonTransposedLine);
    }

    public void addTransposed(ReadByLine readByLine) throws CSVReaderException {
        List<String[]> rows = AddWithName.readRowsFromCSV(readByLine);
        if (rows.isEmpty()) {
            return;
        }
        int numCols = rows.get(0).length;
        int firstCol = 0;
        try {
            if (this.firstLineHeaders) {
                if (!this.writer.hasWrittenHeaders()) {
                    List<String> headers = TypedValueUtilities.createArrayFromList(rows, 0);
                    this.writeHeaders(headers);
                }
                firstCol = 1;
            }
            for (int c = firstCol; c < numCols; ++c) {
                List<TypedValue> colData = TypedValueUtilities.createTypedArrayFromList(rows, c);
                this.writeRow(colData);
            }
        }
        catch (OperationFailedException e) {
            throw new CSVReaderException((Throwable)e);
        }
    }

    private void addNonTransposedLine(String[] line, boolean firstLine) throws OperationFailedException {
        if (firstLine && this.firstLineHeaders) {
            if (!this.writer.hasWrittenHeaders()) {
                this.writeHeaders(TypedValueUtilities.listFromArray(line));
            }
            return;
        }
        this.writeRow(TypedValueUtilities.typeArray(line));
    }

    private void writeHeaders(List<String> list) {
        if (this.name != null) {
            list.add(0, "name");
        }
        this.writer.writeHeaders(list);
    }

    private void writeRow(List<TypedValue> list) {
        if (this.name != null) {
            list.add(0, new TypedValue(this.name));
        }
        this.writer.writeRow(list);
    }

    private static List<String[]> readRowsFromCSV(ReadByLine readByLine) throws CSVReaderException {
        ArrayList<String[]> rows = new ArrayList<String[]>();
        readByLine.read((line, firstLine) -> rows.add(line));
        return rows;
    }
}

