/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.task;

import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.experiment.ExperimentExecutionException;
import org.anchoranalysis.experiment.JobExecutionException;
import org.anchoranalysis.experiment.bean.task.Task;
import org.anchoranalysis.experiment.task.InputBound;
import org.anchoranalysis.experiment.task.InputTypesExpected;
import org.anchoranalysis.experiment.task.ParametersExperiment;
import org.anchoranalysis.inference.concurrency.ConcurrencyPlan;
import org.anchoranalysis.io.generator.tabular.CSVWriter;
import org.anchoranalysis.io.input.csv.CSVReaderByLine;
import org.anchoranalysis.io.input.csv.CSVReaderException;
import org.anchoranalysis.io.input.csv.ReadByLine;
import org.anchoranalysis.io.input.file.FileInput;
import org.anchoranalysis.io.output.enabled.OutputEnabledMutable;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;
import org.anchoranalysis.io.output.outputter.InputOutputContext;
import org.anchoranalysis.io.output.outputter.Outputter;
import org.anchoranalysis.io.output.outputter.OutputterChecked;
import org.anchoranalysis.plugin.io.bean.task.AddWithName;

public class CombineCSV
extends Task<FileInput, CSVWriter> {
    private static final String OUTPUT_COMBINED = "combined";
    @BeanField
    private String seperator = ",";
    @BeanField
    private boolean firstLineHeaders = true;
    @BeanField
    private boolean transposed = false;
    @BeanField
    private boolean addName = true;

    public CSVWriter beforeAnyJobIsExecuted(Outputter outputter, ConcurrencyPlan concurrencyPlan, List<FileInput> inputs, ParametersExperiment parameters) throws ExperimentExecutionException {
        try {
            Optional writer = CSVWriter.createFromOutputter((String)OUTPUT_COMBINED, (OutputterChecked)outputter.getChecked());
            if (!writer.isPresent()) {
                throw new ExperimentExecutionException("'featureReport' output not enabled, as is required");
            }
            return (CSVWriter)writer.get();
        }
        catch (OutputWriteFailedException e) {
            throw new ExperimentExecutionException((Throwable)e);
        }
    }

    public boolean hasVeryQuickPerInputExecution() {
        return false;
    }

    public InputTypesExpected inputTypesExpected() {
        return new InputTypesExpected(FileInput.class);
    }

    public void doJobOnInput(InputBound<FileInput, CSVWriter> parameters) throws JobExecutionException {
        FileInput fileInput = (FileInput)parameters.getInput();
        CSVWriter writer = (CSVWriter)parameters.getSharedState();
        if (writer == null || !writer.isOutputEnabled()) {
            return;
        }
        Path inputPath = fileInput.getFile().toPath();
        try (ReadByLine readByLine = CSVReaderByLine.open((Path)inputPath, (String)this.seperator, (boolean)this.firstLineHeaders);){
            String name = this.addName ? fileInput.identifier() : null;
            AddWithName addWithName = new AddWithName(writer, this.firstLineHeaders, name);
            if (this.transposed) {
                addWithName.addTransposed(readByLine);
            } else {
                addWithName.addNonTransposed(readByLine);
            }
        }
        catch (CSVReaderException e) {
            throw new JobExecutionException((Throwable)e);
        }
    }

    public void afterAllJobsAreExecuted(CSVWriter writer, InputOutputContext context) throws ExperimentExecutionException {
        if (writer != null) {
            writer.close();
        }
    }

    public OutputEnabledMutable defaultOutputs() {
        return super.defaultOutputs().addEnabledOutputFirst(new String[]{OUTPUT_COMBINED});
    }

    @Generated
    public String getSeperator() {
        return this.seperator;
    }

    @Generated
    public void setSeperator(String seperator) {
        this.seperator = seperator;
    }

    @Generated
    public boolean isFirstLineHeaders() {
        return this.firstLineHeaders;
    }

    @Generated
    public void setFirstLineHeaders(boolean firstLineHeaders) {
        this.firstLineHeaders = firstLineHeaders;
    }

    @Generated
    public boolean isTransposed() {
        return this.transposed;
    }

    @Generated
    public void setTransposed(boolean transposed) {
        this.transposed = transposed;
    }

    @Generated
    public boolean isAddName() {
        return this.addName;
    }

    @Generated
    public void setAddName(boolean addName) {
        this.addName = addName;
    }
}

