/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.task;

import java.nio.file.Path;
import java.util.List;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.log.MessageLogger;
import org.anchoranalysis.experiment.ExperimentExecutionException;
import org.anchoranalysis.experiment.JobExecutionException;
import org.anchoranalysis.experiment.arguments.ExecutionArguments;
import org.anchoranalysis.experiment.bean.task.Task;
import org.anchoranalysis.experiment.task.InputBound;
import org.anchoranalysis.experiment.task.ParametersExperiment;
import org.anchoranalysis.inference.concurrency.ConcurrencyPlan;
import org.anchoranalysis.io.input.InputFromManager;
import org.anchoranalysis.io.output.outputter.InputOutputContext;
import org.anchoranalysis.io.output.outputter.Outputter;
import org.anchoranalysis.plugin.io.bean.summarizer.Summarizer;
import org.anchoranalysis.plugin.io.bean.summarizer.SummarizerCount;

public abstract class SummarizeBase<T extends InputFromManager, S>
extends Task<T, Summarizer<S>> {
    @BeanField
    private Summarizer<S> summarizer = new SummarizerCount<S>();

    public Summarizer<S> beforeAnyJobIsExecuted(Outputter outputter, ConcurrencyPlan concurrencyPlan, List<T> inputs, ParametersExperiment parameters) throws ExperimentExecutionException {
        if (parameters.isDetailedLogging()) {
            this.summarizeExperimentArguments((MessageLogger)parameters.getLoggerExperiment(), parameters.getExecutionArguments());
        }
        return this.summarizer;
    }

    public void doJobOnInput(InputBound<T, Summarizer<S>> input) throws JobExecutionException {
        try {
            ((Summarizer)((Object)input.getSharedState())).add(this.extractObjectForSummary((InputFromManager)input.getInput()));
        }
        catch (OperationFailedException e) {
            String message = String.format("Cannot summarize %s", ((InputFromManager)input.getInput()).pathForBinding().map(Path::toString).orElse("the input."));
            throw new JobExecutionException(message, (Throwable)e);
        }
    }

    public void afterAllJobsAreExecuted(Summarizer<S> sharedState, InputOutputContext context) throws ExperimentExecutionException {
        try {
            context.getMessageReporter().log(sharedState.describe());
        }
        catch (OperationFailedException e) {
            throw new ExperimentExecutionException((Throwable)e);
        }
    }

    public boolean hasVeryQuickPerInputExecution() {
        return true;
    }

    protected abstract S extractObjectForSummary(T var1);

    private void summarizeExperimentArguments(MessageLogger log, ExecutionArguments arguments) {
        arguments.input().getContextParameters().getInputDirectory().ifPresent(dir -> log.logFormatted("An input-directory has been set as %s", new Object[]{dir}));
        arguments.output().getPrefixer().getOutputDirectory().ifPresent(dir -> log.logFormatted("An output-directory has been set as %s", new Object[]{dir}));
    }

    @Generated
    public Summarizer<S> getSummarizer() {
        return this.summarizer;
    }

    @Generated
    public void setSummarizer(Summarizer<S> summarizer) {
        this.summarizer = summarizer;
    }
}

