/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.multifile;

import java.nio.file.Path;
import java.util.Optional;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.io.ImageIOException;
import org.anchoranalysis.image.io.stack.time.TimeSeries;
import org.anchoranalysis.image.voxel.datatype.VoxelDataType;
import org.anchoranalysis.plugin.io.multifile.DataTypeChecker;
import org.anchoranalysis.plugin.io.multifile.ParsedFilePathBag;
import org.anchoranalysis.plugin.io.multifile.SizeExtents;
import org.anchoranalysis.plugin.io.multifile.buffer.MultiBufferSized;

class MultiFile {
    private SizeExtents size;
    private DataTypeChecker dataTypeChecker = new DataTypeChecker();
    private MultiBufferSized buffers;

    public MultiFile(ParsedFilePathBag fileBag) {
        this.size = new SizeExtents(fileBag);
    }

    public void add(Stack stackForFile, Optional<Integer> channelNum, Optional<Integer> sliceNum, Optional<Integer> timeIndex, Path filePath) throws ImageIOException {
        this.dataTypeChecker.check(stackForFile);
        if (this.buffers == null) {
            this.buffers = new MultiBufferSized(stackForFile, this.size);
        }
        assert (this.size.hasNecessaryExtents());
        this.checkChannelNum(stackForFile, channelNum, filePath);
        this.checkSliceNum(stackForFile, sliceNum, filePath);
        this.buffers.populateFrom(stackForFile, channelNum, sliceNum, timeIndex);
    }

    public TimeSeries createSequence() {
        return this.buffers.createSequence(this.dataTypeChecker.getDataType());
    }

    private void checkSliceNum(Stack stackForFile, Optional<Integer> sliceNum, Path filePath) throws ImageIOException {
        if (sliceNum.isPresent()) {
            if (stackForFile.dimensions().z() != 1) {
                throw new ImageIOException(String.format("A sliceNum %d is specified, but the file '%s' has more than one slice", sliceNum.get(), filePath));
            }
        } else if (stackForFile.dimensions().z() != this.size.getRangeZ().getSize()) {
            throw new ImageIOException(String.format("File '%s' has an incorrect number of slices", filePath));
        }
    }

    private void checkChannelNum(Stack stackForFile, Optional<Integer> channelNum, Path filePath) throws ImageIOException {
        if (channelNum.isPresent()) {
            if (stackForFile.getNumberChannels() != 1) {
                throw new ImageIOException(String.format("A channelNum %d is specified, but the file '%s' has more than one channel", channelNum.get(), filePath));
            }
        } else if (stackForFile.getNumberChannels() != this.size.getRangeC().getSize()) {
            throw new ImageIOException(String.format("File '%s' has an incorrect number of channels", filePath));
        }
    }

    public int numChannel() {
        return this.size.getRangeC().getSize();
    }

    public int numFrames() {
        return this.size.getRangeT().getSize();
    }

    public boolean numFramesDefined() {
        return this.size.rangeTPresent();
    }

    public boolean numChannelDefined() {
        return this.size.rangeCPresent();
    }

    public VoxelDataType dataType() {
        return this.dataTypeChecker.getDataType();
    }
}

