/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.multifile;

import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.core.time.ExecutionTimeRecorder;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.stack.ImageLocation;
import org.anchoranalysis.image.core.stack.ImagePyramidMetadata;
import org.anchoranalysis.image.io.ImageIOException;
import org.anchoranalysis.image.io.bean.stack.reader.StackReader;
import org.anchoranalysis.image.io.stack.input.ImageTimestampsAttributes;
import org.anchoranalysis.image.io.stack.input.OpenedImageFile;
import org.anchoranalysis.image.io.stack.time.TimeSeries;
import org.anchoranalysis.plugin.io.multifile.FileDetails;
import org.anchoranalysis.plugin.io.multifile.MultiFile;
import org.anchoranalysis.plugin.io.multifile.ParsedFilePathBag;

public class OpenedMultiFile
implements OpenedImageFile {
    private final StackReader stackReader;
    private final ParsedFilePathBag fileBag;
    private final ExecutionTimeRecorder executionTimeRecorder;
    private MultiFile multiFileMemo = null;

    public int numberSeries() {
        return 1;
    }

    public TimeSeries open(int seriesIndex, Logger logger) throws ImageIOException {
        return this.getOrCreateMemo(logger).createSequence();
    }

    public Optional<List<String>> channelNames(Logger logger) {
        return Optional.empty();
    }

    public int numberChannels(Logger logger) throws ImageIOException {
        MultiFile memo = this.getOrCreateMemo(logger);
        if (!memo.numChannelDefined()) {
            throw new ImageIOException("Number of channel is not defined");
        }
        return memo.numChannel();
    }

    public int bitDepth(Logger logger) throws ImageIOException {
        MultiFile memo = this.getOrCreateMemo(logger);
        return memo.dataType().bitDepth();
    }

    public boolean isRGB(Logger logger) throws ImageIOException {
        return false;
    }

    public int numberFrames(Logger logger) throws ImageIOException {
        MultiFile multiFile = this.getOrCreateMemo(logger);
        if (!multiFile.numFramesDefined()) {
            throw new ImageIOException("Number of frames is not defined");
        }
        return multiFile.numFrames();
    }

    public ImageTimestampsAttributes timestamps() throws ImageIOException {
        throw new ImageIOException("Timestamps are not supported for multi-files, as it is not well-defined which file should be used.");
    }

    public Optional<ImageLocation> location() throws ImageIOException {
        throw new ImageIOException("A location is not supported for multi-files, as it is not well-defined which file should be used.");
    }

    public void close() throws ImageIOException {
    }

    public Dimensions dimensionsForSeries(int seriesIndex, Logger logger) throws ImageIOException {
        throw new ImageIOException("MultiFileReader doesn't support this operation");
    }

    public Optional<ImagePyramidMetadata> pyramid() throws ImageIOException {
        return Optional.empty();
    }

    private void addDetailsFromBag(MultiFile multiFile, int seriesIndex, Logger logger) throws ImageIOException {
        for (FileDetails details : this.fileBag) {
            try (OpenedImageFile imageFile = this.stackReader.openFile(details.getPath(), this.executionTimeRecorder);){
                TimeSeries timeSequence = imageFile.open(seriesIndex, logger);
                multiFile.add(timeSequence.getFrame(0), details.getChannelIndex(), details.getSliceIndex(), details.getTimeIndex(), details.getPath());
            }
        }
    }

    private MultiFile getOrCreateMemo(Logger logger) throws ImageIOException {
        if (this.multiFileMemo == null) {
            this.multiFileMemo = new MultiFile(this.fileBag);
            this.addDetailsFromBag(this.multiFileMemo, 0, logger);
        }
        return this.multiFileMemo;
    }

    @Generated
    public OpenedMultiFile(StackReader stackReader, ParsedFilePathBag fileBag, ExecutionTimeRecorder executionTimeRecorder) {
        this.stackReader = stackReader;
        this.fileBag = fileBag;
        this.executionTimeRecorder = executionTimeRecorder;
    }
}

