/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.multifile.buffer;

import java.util.Optional;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.channel.factory.ChannelFactory;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.dimensions.IncorrectImageSizeException;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.VoxelsUntyped;
import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.image.voxel.datatype.VoxelDataType;
import org.anchoranalysis.plugin.io.multifile.SizeExtents;

class MultiBuffer {
    private VoxelBuffer[][][] buffers;
    private SizeExtents size;

    public MultiBuffer(Stack stackArbitrarySlice, SizeExtents size) {
        this.size = size;
        size.populateMissingFromArbitrarySlice(stackArbitrarySlice);
        this.buffers = new VoxelBuffer[size.getRangeT().getSize()][size.getRangeC().getSize()][size.getRangeZ().getSize()];
    }

    public void populateWithSpecifiedChannel(Stack stackForFile, int channelNum, Optional<Integer> sliceNum, int timeIndex) {
        Channel channel = stackForFile.getChannel(0);
        Voxels voxels = channel.voxels().any();
        int channelIndexResolved = this.size.getRangeC().index(channelNum);
        int timeIndexResolved = this.size.getRangeT().index(timeIndex);
        if (sliceNum.isPresent()) {
            this.copyFirstSliceForChannel(timeIndexResolved, channelIndexResolved, voxels, sliceNum.get());
        } else {
            this.copyAllSlicesForChannel(timeIndexResolved, channelIndexResolved, voxels);
        }
    }

    public void populateWithSpecifiedSlice(Stack stackForFile, int sliceNum, int timeIndex) {
        int timeIndexResolved = this.size.getRangeT().index(timeIndex);
        for (int c = 0; c < stackForFile.getNumberChannels(); ++c) {
            Channel channel = stackForFile.getChannel(c);
            this.copyFirstSliceForChannel(timeIndexResolved, c, channel.voxels().any(), sliceNum);
        }
    }

    public void populateNoSpecifics(Stack stackForFile, int timeIndex) {
        int timeIndexResolved = this.size.getRangeT().index(timeIndex);
        for (int c = 0; c < stackForFile.getNumberChannels(); ++c) {
            Channel channel = stackForFile.getChannel(c);
            this.copyAllSlicesForChannel(timeIndexResolved, c, channel.voxels().any());
        }
    }

    public Stack createStackForIndex(int t, Dimensions dimensions, VoxelDataType dataType) {
        Stack stack = new Stack();
        for (int c = 0; c < this.size.getRangeC().getSize(); ++c) {
            Channel channel = ChannelFactory.instance().createUninitialised(dimensions, dataType);
            this.copyAllBuffersTo(t, c, channel.voxels());
            try {
                stack.addChannel(channel);
                continue;
            }
            catch (IncorrectImageSizeException e) {
                assert (false);
                continue;
            }
        }
        return stack;
    }

    private void copyAllBuffersTo(int t, int c, VoxelsUntyped voxels) {
        for (int z = 0; z < this.size.getRangeZ().getSize(); ++z) {
            voxels.any().replaceSlice(z, this.buffers[t][c][z]);
        }
    }

    private void copyFirstSliceForChannel(int t, int c, Voxels<?> voxels, int sliceNum) {
        this.buffers[t][c][this.size.getRangeZ().index((int)sliceNum)] = voxels.slice(0);
    }

    private void copyAllSlicesForChannel(int t, int c, Voxels<?> voxels) {
        for (int z = 0; z < voxels.extent().z(); ++z) {
            this.buffers[t][c][z] = voxels.slice(z);
        }
    }
}

