/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.naming.interval;

import java.time.format.DateTimeFormatter;
import org.anchoranalysis.core.exception.friendly.AnchorImpossibleSituationException;

public enum DateStyle {
    INCLUDE_ENTIRELY,
    IGNORE_YEAR,
    OMIT;

    private static final String DATE_WITH_YEAR_PATTERN = "yyyy-MM-dd";
    private static final String DATE_WITHOUT_YEAR_PATTERN = "MMM-dd";

    public DateTimeFormatter formatter() {
        if (this == OMIT) {
            throw new AnchorImpossibleSituationException();
        }
        return DateTimeFormatter.ofPattern(this.pattern());
    }

    public String pattern() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> DATE_WITH_YEAR_PATTERN;
            case 1 -> DATE_WITHOUT_YEAR_PATTERN;
            case 2 -> throw new AnchorImpossibleSituationException();
        };
    }
}

