/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.naming.interval;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import lombok.Generated;
import org.anchoranalysis.plugin.io.naming.interval.DateStyle;
import org.anchoranalysis.plugin.io.naming.interval.TimeStyle;

public class TimeIntervalNamer {
    private ZoneOffset offset;

    public String nameFor(LocalDateTime start, LocalDateTime end, DateStyle dateStyle, TimeStyle timeStyle) {
        boolean singleDay = TimeIntervalNamer.coversSingleDay(start, end);
        if (timeStyle == TimeStyle.OMIT) {
            if (dateStyle == DateStyle.OMIT) {
                dateStyle = DateStyle.IGNORE_YEAR;
            }
            if (singleDay) {
                return TimeIntervalNamer.formatted(start, dateStyle.formatter());
            }
            return TimeIntervalNamer.join(start, end, dateStyle.formatter());
        }
        if (dateStyle == DateStyle.OMIT) {
            return this.joinTime(start, end, dateStyle, timeStyle);
        }
        if (singleDay) {
            return TimeIntervalNamer.formatted(start, dateStyle.formatter()) + " " + this.joinTime(start, end, DateStyle.OMIT, timeStyle);
        }
        return this.joinTime(start, end, dateStyle, timeStyle);
    }

    private String joinTime(LocalDateTime start, LocalDateTime end, DateStyle dateStyle, TimeStyle timeStyle) {
        DateTimeFormatter formatter = timeStyle.patternWithDate(dateStyle);
        if (dateStyle == DateStyle.OMIT && timeStyle == TimeStyle.IGNORE_SECONDS && this.spansSameMinute(start, end)) {
            return TimeIntervalNamer.formatted(start, formatter);
        }
        return TimeIntervalNamer.join(start, end, formatter);
    }

    private static String join(LocalDateTime start, LocalDateTime end, DateTimeFormatter formatter) {
        String first = TimeIntervalNamer.formatted(start, formatter);
        String second = TimeIntervalNamer.formatted(end, formatter);
        return String.join((CharSequence)" to ", first, second);
    }

    private static boolean coversSingleDay(LocalDateTime min, LocalDateTime max) {
        return min.toLocalDate().equals(max.toLocalDate());
    }

    private static String formatted(LocalDateTime dateTime, DateTimeFormatter formatter) {
        return formatter.format(dateTime);
    }

    private boolean spansSameMinute(LocalDateTime start, LocalDateTime end) {
        long endInstant;
        long startInstant = start.toEpochSecond(this.offset);
        return startInstant / 60L == (endInstant = end.toEpochSecond(this.offset)) / 60L;
    }

    @Generated
    public TimeIntervalNamer(ZoneOffset offset) {
        this.offset = offset;
    }
}

