/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.shared;

import java.util.Map;
import java.util.TreeMap;
import org.anchoranalysis.core.value.LanguageUtilities;

public class FrequencyMap<T> {
    private Map<T, Integer> map = new TreeMap<T, Integer>();

    public synchronized void incrementCount(T key) {
        Integer count = this.map.get(key);
        Integer countToAssign = count == null ? 1 : count + 1;
        this.map.put(key, countToAssign);
    }

    public synchronized String describe(String noun) {
        int numKeys = this.map.keySet().size();
        return switch (numKeys) {
            case 0 -> "No inputs have been found yet.";
            case 1 -> String.format("with uniform %s = %s", noun, this.map.keySet().iterator().next());
            default -> this.describeDiverse(noun);
        };
    }

    private String describeDiverse(String noun) {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("with diverse %s:", LanguageUtilities.pluralize((String)noun)));
        for (Map.Entry<T, Integer> entry : this.map.entrySet()) {
            builder.append(String.format(" %s(%d)", entry.getKey(), entry.getValue()));
        }
        return builder.toString();
    }
}

