/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.shared;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.anchoranalysis.core.log.error.ErrorReporter;
import org.anchoranalysis.core.value.TypedValue;
import org.anchoranalysis.io.generator.tabular.CSVWriter;
import org.anchoranalysis.io.output.outputter.Outputter;
import org.anchoranalysis.io.output.outputter.OutputterChecked;

class PathMappingCSV {
    private static final List<String> CSV_HEADERS = Arrays.asList("index", "source_path", "destination_path", "source_filename", "destination_filename");
    private final Optional<CSVWriter> writer;

    public PathMappingCSV(String outputName, Outputter outputter) {
        this.writer = CSVWriter.createFromOutputterWithHeaders((String)outputName, (OutputterChecked)outputter.getChecked(), () -> CSV_HEADERS, (ErrorReporter)outputter.getErrorReporter());
    }

    public void maybeWriteRow(Path source, Path destination, int index) {
        if (this.writer.isPresent()) {
            this.writer.get().writeRow(PathMappingCSV.buildCSVRow(source, destination, index));
        }
    }

    private static List<TypedValue> buildCSVRow(Path source, Path destination, int index) {
        return Arrays.asList(new TypedValue(index), PathMappingCSV.pathValue(source), PathMappingCSV.pathValue(destination), PathMappingCSV.fileNameValue(source), PathMappingCSV.fileNameValue(destination));
    }

    private static TypedValue pathValue(Path path) {
        return new TypedValue(path.toString());
    }

    private static TypedValue fileNameValue(Path path) {
        return new TypedValue(path.getFileName().toString());
    }
}

