/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.xml;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.function.ToDoubleFunction;
import javax.xml.parsers.ParserConfigurationException;
import lombok.Generated;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.serialize.XMLParser;
import org.anchoranalysis.image.core.dimensions.Resolution;
import org.anchoranalysis.image.io.ImageIOException;
import org.anchoranalysis.io.output.xml.XMLWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class ResolutionAsXML {
    private static final String ELEMENT_NAME_ROOT = "metadata";
    private static final String ELEMENT_NAME_RESOLUTION = "resolution";
    private static final String ELEMENT_NAME_X = "width";
    private static final String ELEMENT_NAME_Y = "height";
    private static final String ELEMENT_NAME_Z = "depth";

    public static Resolution readResolutionXml(File file) throws ImageIOException {
        try {
            Document document = XMLParser.parse((File)file);
            document.getDocumentElement().normalize();
            NodeList allResolutionElements = document.getElementsByTagName(ELEMENT_NAME_RESOLUTION);
            if (allResolutionElements.getLength() != 1) {
                throw new ImageIOException("There must be only one resolution tag.");
            }
            return ResolutionAsXML.resolutionFromNodes(allResolutionElements.item(0).getChildNodes());
        }
        catch (IOException | ParserConfigurationException | CreateException | SAXException e) {
            throw new ImageIOException("An error occurred parsing a file containing image-resolution", e);
        }
    }

    public static void writeResolutionXML(Resolution resolution, Path path) throws ImageIOException {
        try {
            Document document = XMLParser.createNewDocument();
            Element root = document.createElement(ELEMENT_NAME_ROOT);
            document.appendChild(root);
            Element elementResolution = document.createElement(ELEMENT_NAME_RESOLUTION);
            root.appendChild(elementResolution);
            ResolutionAsXML.appendDimension(document, ELEMENT_NAME_X, resolution, Resolution::x, elementResolution);
            ResolutionAsXML.appendDimension(document, ELEMENT_NAME_Y, resolution, Resolution::y, elementResolution);
            ResolutionAsXML.appendDimension(document, ELEMENT_NAME_Z, resolution, Resolution::z, elementResolution);
            XMLWriter.writeXMLToFile((Document)document, (Path)path);
        }
        catch (IOException | ParserConfigurationException e) {
            throw new ImageIOException(e.toString());
        }
    }

    private static void appendDimension(Document document, String elementName, Resolution resolution, ToDoubleFunction<Resolution> extractDimension, Element elementToAppendTo) {
        Element element = document.createElement(elementName);
        elementToAppendTo.appendChild(element);
        element.appendChild(ResolutionAsXML.textNode(document, resolution, extractDimension));
    }

    private static Text textNode(Document document, Resolution resolution, ToDoubleFunction<Resolution> extractDimension) {
        return document.createTextNode(Double.toString(extractDimension.applyAsDouble(resolution)));
    }

    private static Resolution resolutionFromNodes(NodeList nodes) throws CreateException {
        Resolution resolution = new Resolution();
        double x = resolution.x();
        double y = resolution.y();
        double z = resolution.z();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equals(ELEMENT_NAME_X)) {
                x = ResolutionAsXML.doubleFromNode(node);
                continue;
            }
            if (node.getNodeName().equals(ELEMENT_NAME_Y)) {
                y = ResolutionAsXML.doubleFromNode(node);
                continue;
            }
            if (!node.getNodeName().equals(ELEMENT_NAME_Z)) continue;
            z = ResolutionAsXML.doubleFromNode(node);
        }
        return new Resolution(x, y, z);
    }

    private static double doubleFromNode(Node node) {
        return Double.parseDouble(node.getTextContent());
    }

    @Generated
    private ResolutionAsXML() {
    }
}

