/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.mpp.bean.convert;

import com.owenfeehan.pathpatternfinder.commonpath.FindCommonPathElements;
import com.owenfeehan.pathpatternfinder.commonpath.PathElements;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.anchoranalysis.experiment.ExperimentExecutionException;
import org.anchoranalysis.image.io.channel.input.NamedChannelsInput;
import org.anchoranalysis.io.input.InputFromManager;

class CommonRootHelper {
    public static <T extends NamedChannelsInput> Path findCommonPathRoot(List<T> inputs) throws ExperimentExecutionException {
        return CommonRootHelper.findCommonPathRootOptional(inputs).orElseThrow(() -> new ExperimentExecutionException("No common root exists for the paths, so cannot copy."));
    }

    private static <T extends NamedChannelsInput> Optional<Path> findCommonPathRootOptional(List<T> inputs) {
        List<Path> paths = CommonRootHelper.extractPaths(inputs);
        if (paths.size() == 1) {
            return Optional.ofNullable(paths.get(0).getParent());
        }
        return FindCommonPathElements.findForFilePaths(paths).map(PathElements::toPath);
    }

    private static <T extends NamedChannelsInput> List<Path> extractPaths(List<T> inputs) {
        return inputs.stream().map(InputFromManager::pathForBinding).filter(Optional::isPresent).map(Optional::get).map(CommonRootHelper::normalizePath).collect(Collectors.toList());
    }

    private static Path normalizePath(Path pathUnormalized) {
        return pathUnormalized.toAbsolutePath().normalize();
    }

    private CommonRootHelper() {
    }
}

