/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.mpp.bean.convert;

import java.nio.file.Path;
import java.util.Optional;
import org.anchoranalysis.core.time.OperationContext;
import org.anchoranalysis.experiment.ExperimentExecutionException;
import org.anchoranalysis.experiment.task.InputTypesExpected;
import org.anchoranalysis.image.core.stack.ImageMetadata;
import org.anchoranalysis.image.io.ImageIOException;
import org.anchoranalysis.image.io.bean.stack.metadata.reader.ImageMetadataReader;
import org.anchoranalysis.image.io.bean.stack.reader.StackReader;
import org.anchoranalysis.image.io.channel.input.NamedChannelsInput;
import org.anchoranalysis.image.io.stack.input.ImageMetadataInput;
import org.anchoranalysis.image.io.stack.input.StackSequenceInput;
import org.anchoranalysis.io.input.InputFromManager;
import org.anchoranalysis.io.input.InputReadFailedException;
import org.anchoranalysis.io.input.file.FileWithDirectoryInput;
import org.anchoranalysis.io.input.file.NamedFile;
import org.anchoranalysis.mpp.io.input.MultiInput;
import org.anchoranalysis.plugin.io.bean.input.stack.ConvertNamedChannelsInputToStack;

class ConvertInputHelper {
    private final ImageMetadataReader imageMetadataReader;
    private final StackReader defaultStackReader;

    public <T extends NamedChannelsInput> InputFromManager convert(T input, InputTypesExpected inputTypesExpected, Optional<Path> directory, OperationContext context) throws ExperimentExecutionException {
        Class<?> inputClass = input.getClass();
        if (inputTypesExpected.doesClassInheritFromAny(inputClass)) {
            return input;
        }
        if (inputTypesExpected.doesClassInheritFromAny(MultiInput.class)) {
            return new MultiInput(input);
        }
        if (inputTypesExpected.doesClassInheritFromAny(StackSequenceInput.class)) {
            return new ConvertNamedChannelsInputToStack(input, context.getExecutionTimeRecorder());
        }
        if (inputTypesExpected.doesClassInheritFromAny(FileWithDirectoryInput.class)) {
            return this.convertToFileWithDirectory(input, directory);
        }
        if (inputTypesExpected.doesClassInheritFromAny(ImageMetadataInput.class)) {
            return this.convertToImageMetadata(input, context);
        }
        throw new ExperimentExecutionException(String.format("Cannot pass or convert the input-type (%s) to match the delegate's expected input-type:%n%s", inputClass, inputTypesExpected));
    }

    public static void addSupportedConversionInputTypes(InputTypesExpected expected) {
        expected.add(MultiInput.class);
        expected.add(StackSequenceInput.class);
        expected.add(FileWithDirectoryInput.class);
        expected.add(ImageMetadataInput.class);
    }

    private <T extends NamedChannelsInput> FileWithDirectoryInput convertToFileWithDirectory(T input, Optional<Path> directory) throws ExperimentExecutionException {
        try {
            NamedFile namedFile = new NamedFile(input.identifier(), input.pathForBindingRequired().toFile());
            return new FileWithDirectoryInput(namedFile, directory.get());
        }
        catch (InputReadFailedException e) {
            throw new ExperimentExecutionException((Throwable)e);
        }
    }

    private <T extends NamedChannelsInput> ImageMetadataInput convertToImageMetadata(T input, OperationContext context) throws ExperimentExecutionException {
        try {
            return new ImageMetadataInput(input.asFile(), () -> this.readImageMetadata(input, context));
        }
        catch (InputReadFailedException e) {
            throw new ExperimentExecutionException((Throwable)e);
        }
    }

    private <T extends NamedChannelsInput> ImageMetadata readImageMetadata(T input, OperationContext context) throws ImageIOException {
        try {
            return this.imageMetadataReader.openFile(input.pathForBindingRequired(), this.defaultStackReader, context);
        }
        catch (InputReadFailedException e) {
            throw new ImageIOException("Failed to read image-metadata for the input.", (Throwable)e);
        }
    }

    public ConvertInputHelper(ImageMetadataReader imageMetadataReader, StackReader defaultStackReader) {
        this.imageMetadataReader = imageMetadataReader;
        this.defaultStackReader = defaultStackReader;
    }
}

