/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.mpp.bean.convert;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.DefaultInstance;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.functional.OptionalFactory;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.core.log.MessageLogger;
import org.anchoranalysis.core.log.error.ErrorReporter;
import org.anchoranalysis.core.log.error.ErrorReporterIntoString;
import org.anchoranalysis.core.time.ExecutionTimeRecorder;
import org.anchoranalysis.core.time.OperationContext;
import org.anchoranalysis.experiment.ExperimentExecutionException;
import org.anchoranalysis.experiment.JobExecutionException;
import org.anchoranalysis.experiment.bean.task.Task;
import org.anchoranalysis.experiment.io.ReplaceTask;
import org.anchoranalysis.experiment.log.MessageLoggerIntoString;
import org.anchoranalysis.experiment.task.InputBound;
import org.anchoranalysis.experiment.task.InputTypesExpected;
import org.anchoranalysis.experiment.task.ParametersExperiment;
import org.anchoranalysis.image.io.bean.stack.metadata.reader.ImageMetadataReader;
import org.anchoranalysis.image.io.bean.stack.reader.StackReader;
import org.anchoranalysis.image.io.channel.input.NamedChannelsInput;
import org.anchoranalysis.inference.concurrency.ConcurrencyPlan;
import org.anchoranalysis.io.input.InputFromManager;
import org.anchoranalysis.io.input.file.FileWithDirectoryInput;
import org.anchoranalysis.io.output.enabled.OutputEnabledMutable;
import org.anchoranalysis.io.output.outputter.InputOutputContext;
import org.anchoranalysis.io.output.outputter.Outputter;
import org.anchoranalysis.plugin.mpp.bean.convert.CommonRootHelper;
import org.anchoranalysis.plugin.mpp.bean.convert.ConvertInputHelper;
import org.anchoranalysis.plugin.mpp.shared.SharedStateRememberConverted;

public class ConvertNamedChannels<T extends NamedChannelsInput, S, U extends InputFromManager>
extends Task<T, SharedStateRememberConverted<U, S>>
implements ReplaceTask<U, S> {
    @BeanField
    private Task<U, S> task;
    @DefaultInstance
    @BeanField
    private ImageMetadataReader imageMetadataReader;
    @DefaultInstance
    @BeanField
    private StackReader defaultStackReaderForMetadata;

    public SharedStateRememberConverted<U, S> beforeAnyJobIsExecuted(Outputter outputter, ConcurrencyPlan concurrencyPlan, List<T> inputs, ParametersExperiment parameters) throws ExperimentExecutionException {
        SharedStateRememberConverted sharedState = new SharedStateRememberConverted();
        List convertedInputs = this.convertListAndPopulateMap(inputs, sharedState, parameters.getExecutionTimeRecorder());
        sharedState.setSharedState(this.task.beforeAnyJobIsExecuted(outputter, concurrencyPlan, convertedInputs, parameters));
        return sharedState;
    }

    public void doJobOnInput(InputBound<T, SharedStateRememberConverted<U, S>> inputBound) throws JobExecutionException {
        Optional inputConverted = ((SharedStateRememberConverted)inputBound.getSharedState()).findConvertedInputFor((NamedChannelsInput)inputBound.getInput(), inputBound.getLogger().messageLogger());
        if (!inputConverted.isPresent()) {
            throw new JobExecutionException("No converted-input can be found in the map");
        }
        this.task.doJobOnInput(inputBound.changeInputAndSharedState((Object)((InputFromManager)inputConverted.get()), ((SharedStateRememberConverted)inputBound.getSharedState()).getSharedState()));
    }

    public InputTypesExpected inputTypesExpected() {
        InputTypesExpected expected = new InputTypesExpected(NamedChannelsInput.class);
        ConvertInputHelper.addSupportedConversionInputTypes(expected);
        return expected;
    }

    public void afterAllJobsAreExecuted(SharedStateRememberConverted<U, S> sharedState, InputOutputContext context) throws ExperimentExecutionException {
        sharedState.forgetAll();
        this.task.afterAllJobsAreExecuted(sharedState.getSharedState(), context);
    }

    public boolean hasVeryQuickPerInputExecution() {
        return this.task.hasVeryQuickPerInputExecution();
    }

    public void replaceTask(Task<U, S> taskToReplace) throws OperationFailedException {
        this.task = taskToReplace;
    }

    public OutputEnabledMutable defaultOutputs() {
        return this.task.defaultOutputs();
    }

    private List<U> convertListAndPopulateMap(List<T> inputs, SharedStateRememberConverted<U, S> sharedState, ExecutionTimeRecorder executionTimeRecorder) throws ExperimentExecutionException {
        Optional<Path> directory = this.deriveCommonRootIfNeeded(inputs);
        assert (!directory.isPresent() || directory.get().toFile().isDirectory());
        ArrayList<InputFromManager> out = new ArrayList<InputFromManager>();
        InputTypesExpected inputTypesExpected = this.task.inputTypesExpected();
        ConvertInputHelper helper = new ConvertInputHelper(this.imageMetadataReader, this.defaultStackReaderForMetadata);
        for (NamedChannelsInput input : inputs) {
            StringBuilder conversionMessages = new StringBuilder();
            InputFromManager converted = helper.convert(input, inputTypesExpected, directory, new OperationContext(executionTimeRecorder, ConvertNamedChannels.logIntoString(conversionMessages)));
            sharedState.rememberConverted(input, converted, conversionMessages);
            out.add(converted);
        }
        return out;
    }

    private Optional<Path> deriveCommonRootIfNeeded(List<T> inputs) throws ExperimentExecutionException {
        InputTypesExpected expectedFromDelegate = this.task.inputTypesExpected();
        return OptionalFactory.createChecked((boolean)expectedFromDelegate.doesClassInheritFromAny(FileWithDirectoryInput.class), () -> CommonRootHelper.findCommonPathRoot(inputs));
    }

    private static Logger logIntoString(StringBuilder builder) {
        ErrorReporterIntoString errorReporter = new ErrorReporterIntoString(builder);
        MessageLoggerIntoString messageLogger = new MessageLoggerIntoString(builder);
        return new Logger((MessageLogger)messageLogger, (ErrorReporter)errorReporter);
    }

    public Task<U, S> getTask() {
        return this.task;
    }

    public void setTask(Task<U, S> task) {
        this.task = task;
    }

    public ImageMetadataReader getImageMetadataReader() {
        return this.imageMetadataReader;
    }

    public void setImageMetadataReader(ImageMetadataReader imageMetadataReader) {
        this.imageMetadataReader = imageMetadataReader;
    }

    public StackReader getDefaultStackReaderForMetadata() {
        return this.defaultStackReaderForMetadata;
    }

    public void setDefaultStackReaderForMetadata(StackReader defaultStackReaderForMetadata) {
        this.defaultStackReaderForMetadata = defaultStackReaderForMetadata;
    }
}

