/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.mpp.bean.define;

import java.util.Optional;
import org.anchoranalysis.core.functional.OptionalUtilities;
import org.anchoranalysis.core.identifier.provider.NamedProviderGetException;
import org.anchoranalysis.core.value.Dictionary;
import org.anchoranalysis.feature.energy.EnergyStack;
import org.anchoranalysis.image.bean.nonbean.init.ImageInitialization;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;
import org.anchoranalysis.io.output.outputter.InputOutputContext;
import org.anchoranalysis.mpp.io.output.EnergyStackWriter;

class EnergyStackHelper {
    private static final String IDENTIFIER = "energyStack";

    public static void writeEnergyStackDictionary(ImageInitialization initialization, Optional<String> energyDictionaryName, InputOutputContext context) {
        try {
            if (initialization.stacks().keys().contains(IDENTIFIER)) {
                Dictionary dictionary = EnergyStackHelper.extractDictionary(initialization, energyDictionaryName);
                EnergyStack energyStack = EnergyStackHelper.createEnergyStack(initialization, dictionary);
                new EnergyStackWriter(energyStack, context.getOutputter()).writeEnergyStack();
            }
        }
        catch (NamedProviderGetException e) {
            context.getLogger().errorReporter().recordError(EnergyStackHelper.class, e.summarize());
        }
        catch (OutputWriteFailedException e) {
            context.getLogger().errorReporter().recordError(EnergyStackHelper.class, (Throwable)e);
        }
    }

    private static EnergyStack createEnergyStack(ImageInitialization initialization, Dictionary dictionary) throws NamedProviderGetException {
        return new EnergyStack((Stack)initialization.stacks().getException(IDENTIFIER), dictionary);
    }

    private static Dictionary extractDictionary(ImageInitialization initialization, Optional<String> energyDictionaryName) throws NamedProviderGetException {
        return OptionalUtilities.flatMap(energyDictionaryName, name -> initialization.dictionaries().getOptional(name)).orElseGet(Dictionary::new);
    }

    private EnergyStackHelper() {
    }
}

